package com.bcxin.oa.old.scheduling;

import com.bcxin.oa.old.service.system.MedicalSocialRecService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.HashMap;


@Component
@Slf4j
public class MedicalMonthJobHandler {

	@Resource
	private MedicalSocialRecService medicalSocialRecService;

	/**
	 * 医社保月结单生成（每个月1号执行）
	 */
	@Scheduled(cron = "0 0 0 1 * ? ")
	public void execute() throws Exception {
		log.info("医社保定时计算启动！");
		medicalSocialRecService.taskGenerateHisRec(new HashMap());
		log.info("MedicalMonthJobHandler执行结束");
	}

}
