package com.bcxin.oa.old.entity.task;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 任务反馈记录
 *
 * @author zhangye
 * @since 2018-02-26 10:42:15
 */
@TableName("com_task_feedback")
@Data
public class ComTaskFeedback extends BaseEntity<ComTaskFeedback> {
	private static final long serialVersionUID = 2081645983L;

	/**
	 * 任务反馈记录ID
	 */
	@ApiModelProperty(value = "任务反馈记录ID")
	private Long taskFeedbackId;

	/**
	 * 任务反馈内容
	 */
	@ApiModelProperty(value = "任务反馈内容")
	private String feedbackContent;

	/**
	 * 反馈人员ID
	 */
	@ApiModelProperty(value = "反馈人员ID")
	private Long feedbackPerId;

	/**
	 * 反馈图片url
	 */
	@ApiModelProperty(value = "反馈图片url")
	private String imageUrl;

	/**
	 * 反馈日期
	 */
	@ApiModelProperty(value = "反馈日期")
	private Date feedbackDates;

	/**
	 * 值班状态（1正常2离岗）
	 */
	@ApiModelProperty(value = "值班状态")
	private String dutyState;

	/**
	 * 离岗原因类别（1执行紧急任务2提前完成任务3请假4其他）
	 */
	@ApiModelProperty(value = "离岗原因类别")
	private String leaveType;

	/**
	 * 离岗原因
	 */
	@ApiModelProperty(value = "离岗原因")
	private String leaveComment;

	/**
	 * 任务ID
	 */
	@ApiModelProperty(value = "任务ID")
	private Long comTaskId;

	/**
	 * 任务执行情况ID
	 */
	@ApiModelProperty(value = "任务执行情况ID")
	private Long taskImplementId;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getTaskFeedbackId() {
		return taskFeedbackId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getFeedbackPerId() {
		return feedbackPerId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getComTaskId() {
		return comTaskId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getTaskImplementId() {
		return taskImplementId;
	}
}