package com.bcxin.oa.old.entity.salary;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 人员薪资发放
 * 
 * @author llc
 * @date 2019-01-01
 */
@Data
@TableName("per_salary_grant")
public class PerSalaryGrant extends BaseEntity<PerSalaryGrant> {

	/** 人员薪资发放ID */
	@ApiModelProperty(value = "人员薪资发放ID")
	private Long perSalaryGrantId;

	/** 开始年月 */
	@ApiModelProperty(value = "发放年月")
	private String grantYears;

	/** 工资总额(不含代扣五险、公积金、个税) */
	@ApiModelProperty(value = "税前工资")
	private BigDecimal sumAmount;

	/** 应税工资(工资总额-五险-公积金) */
	@ApiModelProperty(value = "计税工资")
	private BigDecimal taxableAmount;

	/** 应发工资=工资总额-代扣(五险、公积金、个税) */
	@ApiModelProperty(value = "应发工资")
	private BigDecimal payableAmount;

	/** 实发工资(领导确认或者银行回单)*/
	@ApiModelProperty(value = "实发工资")
	private BigDecimal actualAmount;

	/** 核算状态 */
	@ApiModelProperty(value = "核算状态")
	private String accountStatus;

	/** 核算时间 */
	@ApiModelProperty(value = "核算时间")
	private Date accountTime;

	/** 薪酬模板名称 */
	@ApiModelProperty(value = "薪酬模板名称")
	private String salaryTempName;

	/** 备注 */
	@ApiModelProperty(value = "备注")
	private String remark;

	/** 是否确认 */
	@ApiModelProperty(value = "是否确认")
	private String isConfirm;

	/** 确认时间 */
	@ApiModelProperty(value = "确认时间")
	private Date confirmTime;

	/** 人员ID */
	@ApiModelProperty(value = "人员ID")
	private Long perId;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getPerSalaryGrantId() {
		return perSalaryGrantId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getPerId() {
		return perId;
	}
}