package com.bcxin.oa.old.dto.app;

import com.bcxin.oa.old.common.BaseEntity;
import com.bcxin.oa.old.entity.task.ComTaskAttendAddress;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * APP任务日历列表
 * 
 * @author zhangye
 *
 */
public class AppComTaskCalendarDTO extends BaseEntity<AppComTaskCalendarDTO> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 385881206573256549L;
	/** 任务ID */
	@ApiModelProperty(value = "任务ID")
	private Long taskId;

	/**
	 * 人员ID
	 */
	@ApiModelProperty(value = "人员ID")
	private Long perId;

	/**
	 * 本月第一天是周几（周一：1，周日：0）
	 */
	@ApiModelProperty(value = "本月第一天是周几")
	private Integer startDayForWeek;

	/**
	 * 本月最后一天是几号（例如：30，31）
	 */
	@ApiModelProperty(value = "本月最后一天是几号")
	private Integer endDayNumber;
	/**
	 * 请求显示年
	 */
	@ApiModelProperty(value = "请求显示年")
	private Integer year;
	/**
	 * 请求显示月
	 */
	@ApiModelProperty(value = "请求显示月")
	private Integer month;

	/**
	 * 当前选择日期
	 */
	@ApiModelProperty(value = "当前选择日期")
	private Integer selectDay;

	/**
	 * 当前年
	 */
	@ApiModelProperty(value = "当前年")
	private Integer currentYear;

	/**
	 * 当前月
	 */
	@ApiModelProperty(value = "当前月")
	private Integer currentMonth;

	/**
	 * 当前日期
	 */
	@ApiModelProperty(value = "当前日期")
	private Integer currentDay;

	/**
	 * 当前选择年月日
	 */
	@ApiModelProperty(value = "当前选择日期")
	private String selectDate;
	/**
	 * 任务范围
	 */
	@ApiModelProperty(value = "任务范围")
	private Long scope;

	/**
	 * 查看任务方式（任务地点）
	 *
	 * @param attendGroupId
	 * @return
	 */
	List<ComTaskAttendAddress> arrCoords = new ArrayList<ComTaskAttendAddress>();
	/**
	 * 班次列表
	 */
	@ApiModelProperty(value = "任务班次列表")
	private List<AppComTaskShiftDTO> arrShifts = new ArrayList<AppComTaskShiftDTO>();

	/**
	 * 异常任务班次列表
	 */
	@ApiModelProperty(value = "异常任务班次列表")
	private List<AppComTaskExceptionDTO> arrExceptionAttendance = new ArrayList<AppComTaskExceptionDTO>();

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getPerId() {
		return perId;
	}

	public void setPerId(Long perId) {
		this.perId = perId;
	}

	public Integer getStartDayForWeek() {
		return startDayForWeek;
	}

	public void setStartDayForWeek(Integer startDayForWeek) {
		this.startDayForWeek = startDayForWeek;
	}

	public Integer getEndDayNumber() {
		return endDayNumber;
	}

	public void setEndDayNumber(Integer endDayNumber) {
		this.endDayNumber = endDayNumber;
	}

	public Integer getYear() {
		return year;
	}

	public void setYear(Integer year) {
		this.year = year;
	}

	public Integer getMonth() {
		return month;
	}

	public void setMonth(Integer month) {
		this.month = month;
	}

	public Integer getSelectDay() {
		return selectDay;
	}

	public void setSelectDay(Integer selectDay) {
		this.selectDay = selectDay;
	}

	public Integer getCurrentYear() {
		return currentYear;
	}

	public void setCurrentYear(Integer currentYear) {
		this.currentYear = currentYear;
	}

	public Integer getCurrentMonth() {
		return currentMonth;
	}

	public void setCurrentMonth(Integer currentMonth) {
		this.currentMonth = currentMonth;
	}

	public Integer getCurrentDay() {
		return currentDay;
	}

	public void setCurrentDay(Integer currentDay) {
		this.currentDay = currentDay;
	}

	public String getSelectDate() {
		return selectDate;
	}

	public void setSelectDate(String selectDate) {
		this.selectDate = selectDate;
	}

	public Long getScope() {
		return scope;
	}

	public void setScope(Long scope) {
		this.scope = scope;
	}

	public List<ComTaskAttendAddress> getArrCoords() {
		return arrCoords;
	}

	public void setArrCoords(List<ComTaskAttendAddress> arrCoords) {
		this.arrCoords = arrCoords;
	}

	public List<AppComTaskShiftDTO> getArrShifts() {
		return arrShifts;
	}

	public void setArrShifts(List<AppComTaskShiftDTO> arrShifts) {
		this.arrShifts = arrShifts;
	}

	public List<AppComTaskExceptionDTO> getArrExceptionAttendance() {
		return arrExceptionAttendance;
	}

	public void setArrExceptionAttendance(List<AppComTaskExceptionDTO> arrExceptionAttendance) {
		this.arrExceptionAttendance = arrExceptionAttendance;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getTaskId() {
		return taskId;
	}

	public void setTaskId(Long taskId) {
		this.taskId = taskId;
	}

}
