package com.bcxin.oa.old.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;

import java.util.Map;

/**
 * <p>
 * 接收DB数据库返回的数据，多样的，允许扩充
 * </p>
 *
 * @author 罗鹏
 * @date 2018/3/2
 */
@Data
public class MultiDataDTO {

    /**
     * id 通用
     */
    private Long id;


    /**
     * 任务id
     */
    private Long comTaskId;

    /**
     * 任务名称
     */
    private Long comTaskName;


    /**
     * 班次id
     */
    private Long shiftId;

    /**
     * 班次规则ID
     */
    private Long shiftRuleId;

    /**
     * 排班明细id
     */
    private Long taskImplementId;


    /**
     * 班次名称
     */
    private String shiftName;

    /**
     * 班次别名
     */
    private String shiftAlias;

    /**
     * 人员id
     */
    private Long perId;

    /**
     * 人员名称
     */
    private String perName;

    /**
     * 人员头像url
     */
    private String perPhotoUrl;

    /**
     * 人员手机号
     */
    private String mobilePhone;

    /**
     * 人员身份证号
     */
    private String idCardNo;

    /**
     * 人员部门名称
     */
    private String departName;

    /**
     * 日期
     */
    private String dates;

    /**
     * 出勤状态 （上班打卡状态）
     */
    private String attendStatus;

    /**
     * 是否休息
     */
    private String isRest;

    /**
     * 月份
     */
    private String month;


    /**
     * 是否缺岗
     */
    private String isQg;

    /**
     * 班次区间（09:00:00-12:00:00）
     */
    private String timeNode;


    /**
     * 实际区间（09:00:01-12:00:03）
     */
    private String timeTrueNode;

    /**
     * 实际日期（2018-10-10#2018-10-10）用于判断打卡日期是否是同一天
     */
    private String dayTrueNode;

    /**
     * 第几天
     */
    private String whatDay;

    /**
     * 执行时长
     */
    private String totalTime;


    /**
     * 下班打卡状态
     */
    private String offAttendStatus;

    /**
     * 考勤状态
     */
    private String implementStatus;

    /**
     * 实际情况
     */
    private String realTime;

    /**
     * 考勤状态
     */
    private String numStatus;

    /**
     * 计算人员排班次数
     */
    private Integer counts;

    /**
     * 额外补充字段
     */
    private String extra;

    private Map map;

    /**
     * 是否有效
     */
    private String isActive;

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getComTaskId() {
        return comTaskId;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getShiftId() {
        return shiftId;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getTaskImplementId() {
        return taskImplementId;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getPerId() {
        return perId;
    }

}
