package com.bcxin.oa.old.dto;

import com.bcxin.oa.old.entity.task.ComTask;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * <p>
 * 任务
 * </p>
 *
 * @author 李勇强
 * @since 2018-03-01 16:24:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class ComTaskDto extends ComTask {

    private static final long serialVersionUID = 7954359511331710622L;
    /**
     * 自由工时
     */
    public static final String ATTEND_TYPE_FREE = "3";
    /**
     * 固定班制
     */
    public static final String ATTEND_TYPE_FIXED = "1";
    /**
     * 排班制
     */
    public static final String ATTEND_TYPE_SCHEDUL = "2";
    /**
     * 步骤
     */
    private Integer step;
    /**
     * 是否确认并发布
     */
    private Integer isRelease;
    /**
     * 暂存id
     */
    private Long tempStorageId;

    /**
     * 机构id
     */
    private String institutionTypeId;
    /**
     * 行业id
     */
    private String industryTypeId;


    /**
     * 省市区的集合
     * [350000,123123,123132]
     */
    private int[] allAddress;

    /**
     * 人员ID
     */
    private Long perId;

    /**
     * 班次规则Id
     */
    private Long shiftRuleId;


    /**
     * 紧急程度
     */
    private String urgentLevelLabel;
    /**
     * 任务等级
     */
    private String taskLevelLabel;
    /**
     * 任务考勤类型
     */
    private String attendTypeLabel;
    /**
     * 任务负责人姓名
     */
    private String chargePerName;
    /**
     * 任务创建、修改的页面操作类型，详见枚举
     */
    private Integer tabType;
    /**
     * 任务性质
     */
    private String taskNatureLabel;
    /**
     * 任务状态
     */
    private String taskStatusLabel;
    /**
     * 任务类型
     */
    private String taskTypeLabel;
    /**
     * 任务大类类型
     */
    private String taskBigType;
    /**
     * 任务开始时间格式化
     */
    private String startDateFormat;
    /**
     * 任务结束时间格式化
     */
    private String endDateFormat;
    /**
     * 服务类型中文集合
     */
//    private List<ConfigIndustryDictDto> serviceTypeLabels;
    /**
     * 关键字查询
     */
    private String keyWord;

    /**
     * 企业合同
     */
    private Map<String, Object> comContractMap;

    /**
     * 考勤时间起点
     */
    private String taskStartTime;

    /**
     * 任务类型(大任务/小任务)
     */
    private String taskTypeName;

    /**
     * 服务类型
     */
    private String serviceTypeName;

    /**
     * 固定排班选择的人员
     */
    private String[] perIdArray;


    /**
     * 企业合同列表
     */
    private List<Map<String, Object>> comContractList;

    /**
     * 任务有效性
     */
    private String taskEffect;


    /**
     * 是否关联合同
     */
    private String isRelationContract;

    //新增两个map字段，用于驻勤点同步保存
    /**
     * 关联合同列表
     */
//    private List<Map<String, Object>>  contractList;

    /**
     * 关联人员列表
     */
    private List<Map<String, String>>  perList;

    private String perNum;

    /**
     * 到期月份
     */
    private Integer expiredMonth;

    /**
     * 批量删除任务ID列表
     */
    private List<Long> comTaskIdList;


    /** 所属企业ID */
    @ApiModelProperty(value = "所属企业ID")
    private Long belongComId;
}
