package com.bcxin.oa.old.controller.count;

import com.bcxin.oa.old.dto.count.CountPerTaskDTO;
import com.bcxin.oa.old.dto.count.PerTaskDateDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.service.web.CountPerTaskDateService;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.aspect.Log;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Map;

/**
 * 外勤统计的controller层
 * by llc 2019-01-14
 */
@RestController
@RequestMapping("/task/count/task-count")
@Api(tags = {""}, description = "外勤统计")
public class CountPerTaskDateController extends BaseController {
    @Resource
    private CountPerTaskDateService countPerTaskDateService;

    /**
     * 获取人员外勤日统计列表
     * @param dto
     * @return
     * @author llc
     * @date 2019-01-14
     */
    @Log(operation = Log.OPERA_TYPE_SAVE, modle = "人员外勤日统计分页查询", title = "人员外勤日统计分页查询", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @GetMapping(value = "page-for-count-per-task-date")
    @ApiOperation(value = "人员外勤日统计分页查询", httpMethod = "GET", notes = "人员外勤日统计分页查询", response = Map.class)
    public Result pageForCountPerTaskDate(CountPerTaskDTO dto) {
        return countPerTaskDateService.getPerTaskDateCountList(dto).setBack(getRequest());
    }


    /**
     * 获取人员外勤月统计列表
     * @param dto
     * @return
     * @author llc
     * @date 2019-01-14
     */
    @Log(operation = Log.OPERA_TYPE_SAVE, modle = "人员外勤月统计分页查询", title = "人员外勤月统计分页查询", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @GetMapping(value = "page-for-count-per-task-month")
    @ApiOperation(value = "人员外勤月统计分页查询", httpMethod = "GET", notes = "人员外勤月统计分页查询", response = Map.class)
    public Result pageForCountPerTaskMonth(CountPerTaskDTO dto) {
        return countPerTaskDateService.getPerTaskMonthCountList(dto).setBack(getRequest());
    }


    /**
     * 人员外勤月统计导出
     * @param dto
     * @return
     * @author llc
     * @date 2019-01-14
     */
    @Log(operation = Log.OPERA_TYPE_SAVE, modle = "人员外勤月统计导出", title = "人员外勤月统计导出", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @GetMapping(value = "export-count-per-task-month")
    @ApiOperation(value = "人员外勤月统计导出", httpMethod = "GET", notes = "人员外勤月统计导出")
    public Result exportCountPerTaskMonth(CountPerTaskDTO dto) throws BusinessException {
        return countPerTaskDateService.exportCountPerTaskMonth(dto,getResponse()).setBack(getRequest());
    }

    /**
     * 查询人员某日打卡详情
     * @param dto
     * @return
     * @author llc
     * @date 2019-01-14
     */
    @Log(operation = Log.OPERA_TYPE_SAVE, modle = "查询人员某日打卡详情", title = "查询人员某日打卡详情", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @GetMapping(value = "get-task-record-list")
    @ApiOperation(value = "查询人员某日打卡详情", httpMethod = "GET", notes = "查询人员某日打卡详情")
    public Result getTaskRecodeList(PerTaskDateDTO dto) throws BusinessException {
        return countPerTaskDateService.getTaskRecodeList(dto).setBack(getRequest());
    }


    /**
     * 修改人员打卡记录
     * @param dto
     * @return
     * @author llc
     * @date 2019-01-14
     */
    @Log(operation = Log.OPERA_TYPE_SAVE, modle = "修改人员打卡记录", title = "修改人员打卡记录", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "update-task-record")
    @ApiOperation(value = "修改人员打卡记录", httpMethod = "POST", notes = "修改人员打卡记录")
    public Result updateTaskRecord(PerTaskDateDTO dto) throws BusinessException {
        return countPerTaskDateService.updateTaskRecord(dto).setBack(getRequest());
    }


    /**
     * 定时器生成外勤报表
     *
     * @return
     * @author llc
     * @date 2019-01-14
     */
    @PostMapping(value = "create_task_count_report")
    @Log(operation = Log.OPERA_TYPE_SAVE,  modle = "统计管理", title = "定时器生成外勤报表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @ApiOperation(value = "定时器生成外勤报表",notes = "定时器生成外勤报表")
    public Result createTaskCountReport() throws BusinessException {
        return  countPerTaskDateService.createTaskCountReport() ;
    }

}
