package com.bcxin.oa.old.controller.count;

import com.bcxin.oa.old.dto.CountPerAttendDTO;
import com.bcxin.oa.old.dto.PerAttendDateDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.service.web.CountPerAttendDateService;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.aspect.Log;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Map;

/**
 * 考勤统计的controller层
 * by llc 2018-12-03
 */
@RestController
@RequestMapping("/task/count/attend-count")
@Api(tags = {""}, description = "考勤统计")
public class CountPerAttendDateController extends BaseController {
    @Resource
    private CountPerAttendDateService countPerAttendDateService;

    /**
     * 获取人员考勤日统计列表
     * @param dto
     * @return
     * @author llc
     * @date 2018-12-03
     */
    @Log(operation = Log.OPERA_TYPE_SAVE, modle = "人员考勤日统计分页查询", title = "人员考勤日统计分页查询", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @GetMapping(value = "page-for-count-per-attend-date")
    @ApiOperation(value = "人员考勤日统计分页查询", httpMethod = "GET", notes = "人员考勤日统计分页查询", response = Map.class)
    public Result pageForCountPerAttendDate(CountPerAttendDTO dto) {
        return countPerAttendDateService.getPerAttendDateCountList(dto).setBack(getRequest());
    }


    /**
     * 获取人员考勤月统计列表
     * @param dto
     * @return
     * @author llc
     * @date 2018-12-03
     */
    @Log(operation = Log.OPERA_TYPE_SAVE, modle = "人员考勤月统计分页查询", title = "人员考勤月统计分页查询", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @GetMapping(value = "page-for-count-per-attend-month")
    @ApiOperation(value = "人员考勤月统计分页查询", httpMethod = "GET", notes = "人员考勤月统计分页查询", response = Map.class)
    public Result pageForCountPerAttendMonth(CountPerAttendDTO dto) {
        return countPerAttendDateService.getPerAttendMonthCountList(dto).setBack(getRequest());
    }


    /**
     * 人员考勤月统计导出
     * @param dto
     * @return
     * @author llc
     * @date 2018-12-04
     */
    @Log(operation = Log.OPERA_TYPE_SAVE, modle = "人员考勤月统计导出", title = "人员考勤月统计导出", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @GetMapping(value = "export-count-per-attend-month")
    @ApiOperation(value = "人员考勤月统计导出", httpMethod = "GET", notes = "人员考勤月统计导出")
    public Result exportCountPerAttendMonth(CountPerAttendDTO dto) throws BusinessException {
        return countPerAttendDateService.exportCountPerAttendMonth(dto,getResponse()).setBack(getRequest());
    }

    /**
     * 查询人员某日打卡详情
     * @param dto
     * @return
     * @author llc
     * @date 2018-12-06
     */
    @Log(operation = Log.OPERA_TYPE_SAVE, modle = "查询人员某日打卡详情", title = "查询人员某日打卡详情", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @GetMapping(value = "get-attend-record-list")
    @ApiOperation(value = "查询人员某日打卡详情", httpMethod = "GET", notes = "查询人员某日打卡详情")
    public Result getAttendRecodeList(PerAttendDateDTO dto) throws BusinessException {
        return countPerAttendDateService.getAttendRecodeList(dto).setBack(getRequest());
    }


    /**
     * 修改人员打卡记录
     * @param dto
     * @return
     * @author llc
     * @date 2018-12-06
     */
    @Log(operation = Log.OPERA_TYPE_SAVE, modle = "修改人员打卡记录", title = "修改人员打卡记录", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "update-attend-record")
    @ApiOperation(value = "修改人员打卡记录", httpMethod = "POST", notes = "修改人员打卡记录")
    public Result updateAttendRecord(PerAttendDateDTO dto) throws BusinessException {
        return countPerAttendDateService.updateAttendRecord(dto).setBack(getRequest());
    }


    /**
     * 定时器生成考勤报表
     *
     * @return
     * @author llc
     * @date 2018-12-17
     */
    @PostMapping(value = "create_attend_count_report")
    @Log(operation = Log.OPERA_TYPE_SAVE,  modle = "统计管理", title = "定时器生成考勤报表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @ApiOperation(value = "定时器生成考勤报表",notes = "定时器生成考勤报表")
    public Result createAttendCountReport() throws BusinessException {
        return  countPerAttendDateService.createAttendCountReport() ;
    }

}
