package com.bcxin.oa.old.controller.app.task;

import com.bcxin.oa.old.dto.ComTaskFixedTempDTO;
import com.bcxin.oa.old.dto.app.AppComTaskFeedbackDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.service.task.ComTaskFeedbackService;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.utils.ObjectUtils;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.aspect.Log;
import com.bcxin.oa.old.dto.user.CurrentUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * App接口-添加任务日志记录管理
 *
 * @author zhangjianhua
 * @version 1.0
 */
@RestController
@RequestMapping("/task/app/com/task/feedback/")
@Api(tags = { "" }, description = "APP-任务日志")
public class AppComTaskFeedbackController extends BaseController {

	@Autowired
	private ComTaskFeedbackService comTaskFeedbackService;

	/**
	 * APP-添加任务日志记录
	 *
	 * @param appComTaskFeedbackDto
	 * @return
	 * @author zhangjianhua
	 * @date 2018/03/23
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "APP-添加任务日志记录管理", title = "保存", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "APP-添加任务日志记录", httpMethod = "POST", notes = "保存任务日志记录", response = ComTaskFixedTempDTO.class)
	@PostMapping(value = "add-comtaskfeedback")
	public Result saveComTaskFeedBack(AppComTaskFeedbackDTO appComTaskFeedbackDto) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		AppComTaskFeedbackDTO appComTaskFeedbackDtoParam = Result.getDecodeData(appComTaskFeedbackDto.getAppData(),
				AppComTaskFeedbackDTO.class);
		ObjectUtils.appCopyProperties(appComTaskFeedbackDtoParam, appComTaskFeedbackDto);
		appComTaskFeedbackDtoParam.setFeedbackPerId(currentUser.getPerId());
		Result result = comTaskFeedbackService.saveComTaskFeedBack(appComTaskFeedbackDtoParam).setBack(getRequest());
		result.setData(Result.setEncodeData(result.getData()));
		return result;
	}

	/**
	 * APP-查询任务日志记录
	 *
	 * @param appComTaskFeedbackDto
	 * @return
	 * @author zhangjianhua
	 * @date 2018/03/14
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "APP-查询任务日志记录", title = "保存", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "APP-查询任务日志记录", httpMethod = "POST", notes = "查询任务日志记录", response = ComTaskFixedTempDTO.class)
	@PostMapping(value = "list-comtaskfeedback")
	public Result listComTaskFeedback(AppComTaskFeedbackDTO appComTaskFeedbackDto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		AppComTaskFeedbackDTO appComTaskFeedbackDtoParam = Result.getDecodeData(appComTaskFeedbackDto.getAppData(),
				AppComTaskFeedbackDTO.class);
		ObjectUtils.appCopyProperties(appComTaskFeedbackDtoParam, appComTaskFeedbackDto);
		appComTaskFeedbackDtoParam.setFeedbackPerId(currentUser.getPerId());
		Result result = comTaskFeedbackService.listComTaskFeedback(appComTaskFeedbackDtoParam).setBack(getRequest());
		result.setData(Result.setEncodeData(result.getData()));
		return result;
	}

}
