package com.bcxin.oa.old.common;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * 数据Entity类
 *
 * @author zhangye
 * @version V1.0
 */
@Deprecated
public abstract class BaseEntity<T> extends BaseParam implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 删除标记（0：正常；1：删除）
     */
    public static final String DEL_FLAG_NORMAL = "0";
    public static final String DEL_FLAG_DELETE = "1";

    @ApiModelProperty(hidden = true)
    protected Long createBy; // 创建者
    @ApiModelProperty(hidden = true)
    protected Date createTime = new Date(); // 创建日期
    @ApiModelProperty(hidden = true)
    protected Long updateBy; // 更新者
    @ApiModelProperty(hidden = true)
    protected Date updateTime = new Date(); // 更新日期
    @ApiModelProperty(hidden = true)
    protected String isDelete = "0"; // 删除标记（0：正常；1：删除；2：审核）

    @ApiModelProperty(hidden = true)
    protected Long comId; // 当前用户公司ID

    @ApiModelProperty(hidden = true)
    protected String tlkDomainId; // 当前用户公司ID(天翎)

    @ApiModelProperty(hidden = true)
    private String sessionId; // 子系统登陆会话(公司ID+用户名+密码+机构类别+失效日期)

    public BaseEntity() {
        super();
        this.isDelete = DEL_FLAG_NORMAL;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getCreateBy() {
        return createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @JsonIgnore
    public String getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(String isDelete) {
        this.isDelete = isDelete;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getComId() {
        return comId;
    }

    public void setComId(Long comId) {
        this.comId = comId;
    }

    public String getTlkDomainId() {
        return tlkDomainId;
    }

    public void setTlkDomainId(String tlkDomainId) {
        this.tlkDomainId = tlkDomainId;
    }

    public String getSessionId() {
        return sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }
}
