package com.bcxin.oa.old.service.task;

import com.bcxin.oa.old.common.utils.DateUtils;
import com.bcxin.oa.old.common.utils.IdWorker;
import com.bcxin.oa.old.common.utils.PageInfoUtils;
import com.bcxin.oa.old.mapper.ComTaskInsidePushMapper;
import com.bcxin.oa.old.mapper.ComTaskMapper;
import com.bcxin.oa.old.dto.ComTaskDto;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.*;
import com.bcxin.oa.old.common.utils.ExcelUtil;
import com.github.pagehelper.PageHelper;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

/**
 * 驻勤内部推送
 *
 * @author zhangye
 * @since 2018-02-26 10:04:46
 */
@Service
@Transactional
public class ComTaskInsidePushServiceImpl implements ComTaskInsidePushService {

	@Resource
	private ComTaskInsidePushMapper comTaskInsidePushMapper;

	@Resource
	private ComTaskMapper comTaskMapper;
	@Resource
	private IdWorker idWorker;


	/***
	 * 获取驻勤成员历史记录
	 * @param dto
	 * @author llc
	 * @date 2020-04-08
	 */
	@Override
	public Result getTaskPerRecord(ComTaskDto dto) throws BusinessException {

		if (dto.getComTaskId() == null) {
			throw new BusinessException(Result.ERROR, "驻勤ID不能为空");
		}
		if (dto.getPageNumber() == null) {
			throw new BusinessException(Result.ERROR, "第几页不能为空");
		}
		if (dto.getPageSize() == null) {
			throw new BusinessException(Result.ERROR, "每页多少行不能为空");
		}
		PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
		/*** 获取驻勤成员历史记录 ***/
		List<Map<String, String>> taskPerRecordList = comTaskInsidePushMapper.getTaskPerRecord(dto);
		PageInfoUtils pageInfo = new PageInfoUtils(taskPerRecordList);
		return Result.success(Result.SUCCESS_QUERY_MSG, pageInfo);
	}

	/**
	 * 导出驻勤人员历史记录
	 * @param dto
	 * @author llc
	 * @date 2020-04-08
	 * @return
	 * @throws BusinessException
	 */
	@Override
	public Result exportTaskPerRecord(ComTaskDto dto, HttpServletResponse response) throws BusinessException {
		if (dto.getComTaskId() == null) {
			throw new BusinessException(Result.ERROR, "驻勤ID不能为空");
		}
		OutputStream os = null;
		HSSFWorkbook wb = new HSSFWorkbook();
		try {
			String fileName = "_" + "驻勤人员" + DateUtils.getDate("yyyyMMddHHmmss") + ".xls";
			response.setContentType("application/vnd.ms-excel");
			response.setHeader("Content-Disposition",
					"attachment;fileName=" + new String(fileName.getBytes("gb2312"), "ISO8859-1"));
			os = response.getOutputStream();
			HSSFSheet sheet1 = wb.createSheet("驻勤人员记录");

			List<Map<String, String>> taskPerRecordList = comTaskInsidePushMapper.getTaskPerRecord(dto);

			/*** 填充文本样式 ***/
			CellStyle stringStyle = ExcelUtil.getStringStyle(wb);

			/**** 生成sheet1的内容 ***/
			HSSFFont titleFont = wb.createFont();
			HSSFCellStyle titleStyle = wb.createCellStyle();
			titleFont.setFontHeightInPoints((short) 11);
			titleFont.setColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
			titleFont.setFontName("黑体");
			titleStyle.setAlignment(HorizontalAlignment.CENTER);// 水平居中
			titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);// 垂直居中
			titleStyle.setFont(titleFont);
			titleStyle.setWrapText(true);
			HSSFDataFormat format = wb.createDataFormat();
			titleStyle.setDataFormat(format.getFormat("@"));

			/*** 填充第一行数据 ***/
			HSSFRow rowFirst = sheet1.createRow(0);
			String[] firstArr = {"序号", "姓名", "身份证号", "手机号码", "开始日期", "结束日期"};
			int column;
			for (int i = 0; i < firstArr.length; i++) {
				HSSFCell cell = rowFirst.createCell(i); // 获取第二行的每个单元格
				if (i == 0) {
					column = 1500;
				} else if (i == 2) {
					column = 5000;
				} else {
					column = 4000;
				}
				sheet1.setColumnWidth(i, column); // 设置每列的列宽
				sheet1.setDefaultColumnStyle(i, stringStyle); // 设置单元格格式 --文本格式
				cell.setCellStyle(titleStyle); // 文本格式
			}

			/*** 填充第一行数据 ***/
			for (int i = 0; i < firstArr.length; i++) {
				HSSFCell cell = rowFirst.createCell(i); // 获取第一行的每个单元格
				cell.setCellValue(firstArr[i]);
				cell.setCellStyle(titleStyle);
			}

			/*** 字体颜色样式 ***/
//			CellStyle greenStyle = ExcelUtil.getColorStyle(wb, IndexedColors.SEA_GREEN.index);// 青绿色样式
//			CellStyle redStyle = ExcelUtil.getColorStyle(wb, IndexedColors.RED.index); // 红色样式
			HSSFRow row = null;
			int rowIndex = 1;
			for (Map<String, String> result : taskPerRecordList) {
				row = sheet1.createRow(rowIndex);
				HSSFCell cell0 = row.createCell(0);
				cell0.setCellValue(rowIndex);
				HSSFCell cell1 = row.createCell(1);
				cell1.setCellValue(result.get("perName") != null ? result.get("perName") : null); // 姓名
				HSSFCell cell2 = row.createCell(2);
				cell2.setCellValue(result.get("idCardNo") != null ? result.get("idCardNo") : null); // 身份证号
				HSSFCell cell3 = row.createCell(3);
				cell3.setCellValue(result.get("mobilePhone") != null ? result.get("mobilePhone") : null); // 手机号
				HSSFCell cell4 = row.createCell(4);
				cell4.setCellValue(result.get("startDate") != null ? result.get("startDate") : null); // 结束日期
				HSSFCell cell5 = row.createCell(5);
				cell5.setCellValue(result.get("endDate") != null ? result.get("endDate") : null);// 投保状态
				rowIndex++;
			}
			wb.write(os);
			os.close();
		} catch (Exception e) {
			throw new BusinessException(Result.ERROR, e.getMessage());
		} finally {
			try {
				os.close();
			} catch (IOException e1) {
			}
		}
		return Result.success("导出驻勤人员记录数据文件失败");
	}
}