package com.bcxin.oa.old.service.task;

import cn.hutool.core.date.DateUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.bcxin.oa.old.common.utils.DateUtils;
import com.bcxin.oa.old.common.utils.HttpUtils;
import com.bcxin.oa.old.common.utils.IdWorker;
import com.bcxin.oa.old.common.utils.ObjectUtils;
import com.bcxin.oa.old.mapper.*;
import com.bcxin.oa.old.entity.task.*;
import com.bcxin.oa.old.dto.*;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.service.common.CommonService;
import com.bcxin.oa.old.common.*;
import com.bcxin.oa.old.common.BBDServiceConst;
import com.bcxin.oa.old.common.CommonConst;
import com.bcxin.oa.old.common.DictConst;
import lombok.extern.java.Log;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;

/**
 * 任务执行情况表
 *
 * @author zhangye
 * @since 2018-02-26 10:04:46
 */
@Service
@Transactional
@Log
public class ComTaskImplementServiceImpl implements ComTaskImplementService {

	@Resource
	private ComTaskImplementMapper comTaskImplementMapper;

	@Resource
	private ComTaskMapper comTaskMapper;

	@Resource
	private ComTaskFeedbackMapper comTaskFeedbackMapper;

	@Resource
	private CommonService commonService;

	@Resource
	private ValidateTaskFixedPerMapper validateTaskFixedPerMapper;

	@Resource
	private ValidateTaskFixedMapper validateTaskFixedMapper;

	@Resource
	private ComTaskService comTaskService;

	@Resource
	private ComTaskInsidePushMapper comTaskInsidePushMapper;

	@Resource
	private IdWorker idWorker;
	/**
	 * 获取任务执行情况表
	 *
	 * @param comTaskImplementDto
	 * @return
	 */
	@Override
	public Result listAttendanceRecord(ComTaskImplementDto comTaskImplementDto) throws BusinessException {

		// 任务id不能为空
		if (comTaskImplementDto.getComTaskId() == null || comTaskImplementDto.getComTaskId() == 0L) {
			throw new BusinessException(Result.ERROR, "任务id不能为空");
		}
		// 日期不能为空
		if (StringUtils.isEmpty(comTaskImplementDto.getParamMonth())) {
			throw new BusinessException(Result.ERROR, "日期月份不能为空");
		}

		// 根据任务id， 日期查询 对应人员id --对应前台搜搜日期， 搜搜内容 -该任务的所有记录
		List<MultiDataDTO> rlist = comTaskImplementMapper.listAttendanceRecord(comTaskImplementDto);
		// 人员集合
		Map<String, String> uMap = new HashMap<>();

		// 遍历循环出人员id及人员姓名
		for (MultiDataDTO mulDto : rlist) {
			uMap.put(mulDto.getPerId() + "", mulDto.getPerName());
		}
		// 最终结果集合
		JSONArray array = new JSONArray();

		// 组装每个人员对应日期，
		for (String perId : uMap.keySet()) {
			JSONObject json = new JSONObject();
			json.put("perName", uMap.get(perId));
			json.put("perId", perId);
			for (MultiDataDTO mulDto : rlist) {
				// 人员相同
				if (mulDto.getPerId().toString().equals(perId)) {
					// 判断日期是否已经存在数据了，存在 则继续保存，不存在则新建
					String status = getStatus(mulDto);
					String statusName = getStatusName(mulDto) + ":" + mulDto.getTimeNode()
							+ (StringUtils.isEmpty(mulDto.getTimeTrueNode()) ? ""
									: "（" + mulDto.getTimeTrueNode() + "）");
					if (DictConst.CQ_XX.equals(status)) {
						statusName = getStatusName(mulDto);
					}
					JSONObject dateContent = null;
					if (json.get(mulDto.getDates()) != null) {
						dateContent = (JSONObject) json.get(mulDto.getDates());
					} else {
						dateContent = new JSONObject();
					}
					dateContent.put(status, statusName);
					json.put(mulDto.getDates(), dateContent);
				}
			}
			array.add(json);
		}

		return Result.success(Result.SUCCESS_QUERY_MSG, array);
	}

	/**
	 * 获取出勤对应前端的状态
	 *
	 * @param mulDto
	 * @return
	 */
	private String getStatus(MultiDataDTO mulDto) {
		String attendStatus = mulDto.getAttendStatus();
		String offAttendStatus = mulDto.getOffAttendStatus();
		String isRest = mulDto.getIsRest();
		String isQg = mulDto.getIsQg();
		// codeMap.put("0","休息");
		// codeMap.put("3","出勤异常");
		// codeMap.put("1","出勤正常");
		// codeMap.put("2","缺岗");
		// 数据库字典值
		// public final static String ATTENDSTATUS_ZC = "1"; // 正常
		// public final static String ATTENDSTATUS_CD = "2"; // 迟到
		// public final static String ATTENDSTATUS_ZT = "3"; // 早退
		// public final static String ATTENDSTATUS_QG = "4"; // 缺岗
		// public final static String ATTENDSTATUS_QK = "5"; // 缺卡
		// public final static String ATTENDSTATUS_JB = "6"; // 加班
		// public final static String ATTENDSTATUS_QJ = "7"; // 请假
		// public final static String ATTENDSTATUS_XX = "8"; // 休息
		if (StringUtils.isNotEmpty(isRest) && DictConst.ISREST_Y.equals(isRest)) {
			return DictConst.CQ_XX;
		} else {
			if (StringUtils.isNotEmpty(attendStatus) && StringUtils.isNotEmpty(offAttendStatus)) {
				if (DictConst.ATTENDSTATUS_ZC.equals(attendStatus)
						&& DictConst.ATTENDSTATUS_ZC.equals(offAttendStatus)) {
					return DictConst.CQ_ZC;
				}
			} else if (StringUtils.isEmpty(attendStatus) && StringUtils.isEmpty(offAttendStatus)
					&& StringUtils.isNotEmpty(isQg) && DictConst.QG_Y.equals(isQg)) {
				return DictConst.CQ_QG;
			}
			return DictConst.CQ_YC;
		}
		// if ("正常".equals(attendStatus)) {
		// return "1";
		// } else if ("缺岗".equals(attendStatus)) {
		// return "2";
		// } else if ("休息".equals(attendStatus)) {
		// return "0";
		// }
		// return "3";//出勤异常
	}

	/**
	 * @param mulDto
	 * @return
	 */
	private String getStatusName(MultiDataDTO mulDto) {
		String attendStatus = mulDto.getAttendStatus();
		String offAttendStatus = mulDto.getOffAttendStatus();
		String isRest = mulDto.getIsRest();
		String isQg = mulDto.getIsQg();
		// 两个正常 是 正常
		// 1个正常 一个 迟到 是迟到
		// 0 个正常 是 缺岗
		if (StringUtils.isNotEmpty(isRest) && DictConst.ISREST_Y.equals(isRest)) {
			return "休息";
		}
		if (StringUtils.isNotEmpty(attendStatus) && StringUtils.isNotEmpty(offAttendStatus)
				&& attendStatus.equals(offAttendStatus)) {
			if (DictConst.ATTENDSTATUS_ZC.equals(attendStatus) && DictConst.ATTENDSTATUS_ZC.equals(offAttendStatus)) {
				return "正常";
			}

		} else if (StringUtils.isEmpty(attendStatus) && StringUtils.isEmpty(offAttendStatus)
				&& StringUtils.isNotEmpty(isQg) && DictConst.QG_Y.equals(isQg)) {
			return "缺岗";
		} else if (StringUtils.isEmpty(attendStatus) && StringUtils.isEmpty(offAttendStatus)
				&& StringUtils.isNotEmpty(isQg) && DictConst.QG_N.equals(isQg)) {
			return "迟到";
		} else {
			String status = "";
			if (DictConst.ATTENDSTATUS_QK.equals(offAttendStatus) || DictConst.ATTENDSTATUS_QK.equals(attendStatus)
					|| (StringUtils.isEmpty(offAttendStatus) && DictConst.ATTENDSTATUS_ZC.equals(attendStatus)
							&& DictConst.QG_Y.equals(isQg))
					|| (StringUtils.isEmpty(attendStatus) && DictConst.ATTENDSTATUS_ZC.equals(offAttendStatus))) {
				status = status + "缺卡,";
			}
			if (DictConst.ATTENDSTATUS_JB.equals(offAttendStatus) || DictConst.ATTENDSTATUS_JB.equals(attendStatus)) {
				status = status + "加班,";
			}
			if (DictConst.ATTENDSTATUS_QJ.equals(offAttendStatus) || DictConst.ATTENDSTATUS_QJ.equals(attendStatus)) {
				status = status + "请假,";
			}
			if (DictConst.ATTENDSTATUS_CD.equals(offAttendStatus) || DictConst.ATTENDSTATUS_CD.equals(attendStatus)) {
				status = status + "迟到,";
			}
			if (DictConst.ATTENDSTATUS_ZT.equals(offAttendStatus) || DictConst.ATTENDSTATUS_ZT.equals(attendStatus)) {
				status = status + "早退,";
			}
			if (StringUtils.isNotEmpty(status)) {
				status = status.substring(0, status.length() - 1);
			}
			return status;
		}
		return "";

	}

	/**
	 * 获取任务日志
	 *
	 * @param comTaskFeedbackParamDto
	 * @return
	 */
	@Override
	public Result listTaskLog(ComTaskFeedbackParamDto comTaskFeedbackParamDto) throws BusinessException {

		// 1、检查参数
		Long comTaskId = comTaskFeedbackParamDto.getComTaskId();
		// 检查任务
		this.checkTask(comTaskId);

		// 检查日期或者人员id是否同时为空
		Long perId = comTaskFeedbackParamDto.getPerId();
		String dates = comTaskFeedbackParamDto.getDates();
		if (Objects.isNull(perId) && StringUtils.isBlank(dates)) {
			throw new BusinessException(Result.ERROR, "参数错误，查询日志时，必须是某个员工或者某一天");
		}
		// 2、查询数据
		return Result.success(Result.SUCCESS_QUERY_MSG,
				comTaskFeedbackMapper.listFeedbackByDay(comTaskFeedbackParamDto));

	}

	/**
	 * 任务出勤记录-查看轨迹
	 *
	 * @param comTaskTrackPageParamDto
	 * @return
	 */
	@Override
	public Result showTrack(ComTaskTrackPageParamDto comTaskTrackPageParamDto) throws BusinessException {
		JSONArray array = new JSONArray();
		JSONObject json = new JSONObject();
		// 次日得等数据
		// 1 参数验证
		Long comTaskId = comTaskTrackPageParamDto.getComTaskId();
		// 验证任务
		checkTask(comTaskId);

		String dates = comTaskTrackPageParamDto.getDates();
		Long perId = comTaskTrackPageParamDto.getPerId();
		if (StringUtils.isBlank(dates) && Objects.isNull(perId)) {
			throw new BusinessException(Result.ERROR, "日期和人员ID不能为空");
		}
		// 查询当天该人员的该任务出勤状况
		ComTaskImplementDto comTaskImplementDto = new ComTaskImplementDto();
		comTaskImplementDto.setComId(comTaskTrackPageParamDto.getComId());
		comTaskImplementDto.setComTaskId(comTaskId);
		comTaskImplementDto.setParamDay(comTaskTrackPageParamDto.getDates());
		comTaskImplementDto.setPerId(comTaskTrackPageParamDto.getPerId());
		List<MultiDataDTO> rlist = comTaskImplementMapper.listAttendanceRecord(comTaskImplementDto);
		if (rlist == null) {
			// 数据为空
			return Result.success(Result.SUCCESS_QUERY_MSG, "");
		}

		// 统计时长
		Long totalTime = 0L;
		// 如果数据不会控
		for (MultiDataDTO mulDto : rlist) {
			// 循环出该天，该用户的 轨迹
			JSONObject dateContent = new JSONObject();
			String status = getStatus(mulDto);
			String statusName = getStatusName(mulDto) + ":" + mulDto.getTimeTrueNode();
			int sig = 0;
			if (DictConst.CQ_XX.equals(status)) {
				statusName = getStatusName(mulDto);
				sig = 1;
			}
			dateContent.put(status, statusName + (sig == 1 ? "" : "（" + mulDto.getTimeNode() + "）"));
			dateContent.put("taskImplementId", mulDto.getTaskImplementId() + "");
			array.add(dateContent);
			// 09:00:00-18:00:00

			if (StringUtils.isNotEmpty(mulDto.getTimeNode()) && StringUtils.isNotEmpty(mulDto.getDayTrueNode())) {
				// 打卡时间，两个都存在的时候才能去计算时长
				String times[] = mulDto.getTimeNode().split("-");
				String days[] = mulDto.getDayTrueNode().split("#");
				if (times != null && times.length > 1 && days != null && days.length > 1) {
					String startDate = days[0] + " " + times[0];
					String endDate = days[1] + " " + times[1];
					Date dateStart = DateUtil.parseDate(startDate);
					Date dateEnd = DateUtil.parseDate(endDate);
					// 计算出两个日期相差多少分钟
					totalTime = totalTime + DateUtils.getDateSubDateToMinutes(dateStart, dateEnd);
				}
			}

		}
		// for(int i=0;i<3;i++){
		// JSONObject dateContent = new JSONObject();
		//
		// dateContent.put("2", "缺岗" + ":18:80-13:00（9:00-18:00）");
		// array.add(dateContent);
		// }
		json.put("status", array);
		if (totalTime == 0L) {
			json.put("totalTime", "0");
		} else {
			json.put("totalTime", DateUtils.getDayHourMinute(totalTime));
		}
		return Result.success(Result.SUCCESS_QUERY_MSG, json);
	}

	/**
	 * 获取状态
	 *
	 * @param comTaskImplementDto
	 * @return
	 */
	@Override
	public Result attendanceStatus(ComTaskImplementDto comTaskImplementDto) {

		JSONObject codeMap = new JSONObject();
		codeMap.put("0", "休息");
		codeMap.put("3", "出勤异常");
		codeMap.put("1", "出勤正常");
		codeMap.put("2", "缺岗");
		JSONObject codeMap2 = new JSONObject();
		codeMap2.put("0", "xiu");
		codeMap2.put("3", "yi");
		codeMap2.put("1", "zheng");
		codeMap2.put("2", "que");
		JSONObject jsonCode = new JSONObject();
		jsonCode.put("code2", codeMap2);
		jsonCode.put("code", codeMap);
		return Result.success(Result.SUCCESS_QUERY_MSG, jsonCode);
	}

	/**
	 * 检查任务信息
	 *
	 * @param comTaskId
	 *            任务ID
	 * @return void
	 * @throws BusinessException
	 *             The custom exception, contains bussness message.
	 */
	private void checkTask(Long comTaskId) throws BusinessException {
		// 检查任务id是否为空，为了预防空指针异常
		if (Objects.isNull(comTaskId)) {
			throw new BusinessException(Result.ERROR, "任务ID不可以为空");
		}
		// 检查任务是否存在
		// throw new BusinessException(Result.ERROR, "任务不存在");

	}

	public static void main(String[] args) {
		String[] arrs = { "1", "2" };
		System.out.printf(arrs.length + "");
		// JSONArray array = new JSONArray();
		// JSONObject json = new JSONObject();
		// json.put("taskId", 1L);
		// json.put("perName", "夏利");
		// json.put("perId", "1");
		// // 出勤状态
		// JSONObject json1 = new JSONObject();
		// json1.put("缺岗", "（09:00~12:00）");
		// json1.put("迟到", "13:05~18:05（13:00~18:00）");
		// json1.put("正常", "18:30~20:10（19:00~20:00）");
		// json.put("2017-10-1", json1);
		//
		// array.add(json);
		// System.out.printf(array.toJSONString());
	}


	/**
	 * 定时器生成任务执行情况
	 *
	 * @return
	 * @throws BusinessException
	 * @author zhangjianhua
	 * @date 2018/03/13
	 */
	@Override
	public Result runTaskImplement() throws BusinessException {

		/** 查询需要生成任务执行情况的数据 **/
		List<ComTaskImplement> listComTaskImplement = comTaskImplementMapper.listComTaskImplement();

		if (listComTaskImplement != null && listComTaskImplement.size() > 0) {

			for (ComTaskImplement comTaskImplement : listComTaskImplement) {
				comTaskImplement.setTaskImplementId(idWorker.nextId());
			}
			/** 批量插入任务执行情况表 **/
			int status = comTaskImplementMapper.insertComTaskImplementList(listComTaskImplement);
			if (status <= 0) {
				throw new BusinessException(Result.ERROR, "定时生成任务执行情况失败，请稍后重试");
			}
		}
		return Result.success(Result.SUCCESS_QUERY_MSG);
	}

	/**
	 * APP-查询任务轨迹
	 *
	 * @param comTaskImplementDto
	 * @return
	 * @author zhangjianhua
	 * @date 2018/03/20
	 */
	@Override
	public Result listTaskTrack(ComTaskImplementDto comTaskImplementDto) {

		ComTask comTask = comTaskMapper.getComTaskByPrimaryKey(comTaskImplementDto.getComTaskId());

		Object data = null;

		Map<String, Object> paramMap = new HashMap();

		paramMap.put("taskFeedbackId", comTaskImplementDto.getTaskImplementId());// 任务执行情况Id

		try {
			String result = HttpUtils.doPost(commonService.getSystemConfig(CommonConst.TRACK_ + comTask.getProvince())
					+ BBDServiceConst.TASK_FINDTRACKLIST, paramMap);
			JSONObject jsonback = JSONUtil.parseObj(result);
			boolean successful = (boolean) jsonback.get("successful");
			if (!successful) {
				throw new BusinessException(Result.BUSINESS_ERROR, "查询任务轨迹失败，请稍后重试");
			} else {
				data = jsonback.get("data");
			}
		} catch (Exception e) {
			e.printStackTrace();
			return Result.fail(e.toString());
		}
		return Result.success(Result.SUCCESS_QUERY_MSG, data);
	}

	/**
	 * 任务-发布设置-固定排班-校验人员是否有排班冲突（第三步）
	 *
	 * @return
	 * @throws BusinessException
	 * @author zhangjianhua
	 * @date 2018/03/27
	 */
	@Override
	public Map<String, String> checkPerImplement(ComTaskThreeDTO comTaskThreeDTO) throws BusinessException {

		ComTaskTempDTO comTaskTempDTO = new ComTaskTempDTO();

		comTaskTempDTO.setComTaskId(comTaskThreeDTO.getComTaskId());

		// 获取任务第二步信息
		Result result = comTaskService.getStepTwoDetail(comTaskTempDTO);

		HashMap map = (HashMap) result.getData();

		// 固定任务校验人员列表
		List<ValidateTaskFixedPer> listValidateTaskFixedPer = new ArrayList<>();

		// 固定任务校验列表
		List<ValidateTaskFixed> listValidateTaskFixed = new ArrayList<>();

		// 固定排班将选择的人员
		List<Long> implementPerIdList = new ArrayList<>();

		List<String> listName = new ArrayList<>();

		if (map != null) {

			// 固定排班信息
			ComTaskFixedTempDTO comTaskFixedTempDTO = (ComTaskFixedTempDTO) map.get("GDBZ");

			if (comTaskFixedTempDTO != null) {

				// 固定排班周期
				List<ComTaskFixedDTO> list = comTaskFixedTempDTO.getReturnComTaskFixedDList();

				if (list != null && list.size() == 7) {

					if (comTaskThreeDTO.getTaskPerArray() != null && comTaskThreeDTO.getTaskPerArray().length > 0) {

						for (String perId : comTaskThreeDTO.getTaskPerArray()) {
							implementPerIdList.add(Long.parseLong(perId));
							ValidateTaskFixedPer validateTaskFixedPer = new ValidateTaskFixedPer();
							validateTaskFixedPer.setPerId(Long.parseLong(perId));
							validateTaskFixedPer.setMidTaskId(comTaskThreeDTO.getComTaskId());
							listValidateTaskFixedPer.add(validateTaskFixedPer);
							if (list != null && list.size() > 0) {
								for (ComTaskFixedDTO comTaskFixedDTO : list) {
									ValidateTaskFixed validateTaskFixed = new ValidateTaskFixed();
									validateTaskFixed.setValidateTaskFixedId(idWorker.nextId());
									validateTaskFixed.setMidTaskId(comTaskThreeDTO.getComTaskId());
									validateTaskFixed.setPerId(Long.parseLong(perId));
									validateTaskFixed.setWeekDay(comTaskFixedDTO.getWeekDay());
									validateTaskFixed.setShiftId(comTaskFixedDTO.getShiftId());
									validateTaskFixed.setCreateTime(comTaskThreeDTO.getCreateTime());
									validateTaskFixed.setUpdateTime(comTaskThreeDTO.getUpdateTime());
									validateTaskFixed.setComId(comTaskThreeDTO.getComId());
									listValidateTaskFixed.add(validateTaskFixed);
								}
							}
						}
					}

					if (listValidateTaskFixedPer != null && listValidateTaskFixed.size() > 0) {
						// 批量插入固定任务校验人员表
						int status = validateTaskFixedPerMapper
								.insertValidateTaskFixedPerList(listValidateTaskFixedPer);

						if (status <= 0) {
							throw new BusinessException(Result.ERROR, "校验排班信息失败，请稍后重试");
						}
					}

					if (listValidateTaskFixed != null && listValidateTaskFixed.size() > 0) {
						// 批量插入固定任务校验表
						int status2 = validateTaskFixedMapper.insertValidateTaskFixedList(listValidateTaskFixed);

						if (status2 <= 0) {
							throw new BusinessException(Result.ERROR, "校验排班信息失败，请稍后重试");
						}
					}

					// 获取任务第一步信息
					Result result1 = comTaskService.getStepOneDetail(comTaskTempDTO);

					ComTask comTask = (ComTask) result1.getData();

					// 校验人员固定排班是否冲突,返回冲突的排班信息
					List<Map> mapList = validateTaskFixedMapper.checkImplement(
							DateUtils.formatDate(comTask.getStartDate()), DateUtils.formatDate(comTask.getEndDate()),
							comTaskThreeDTO.getComTaskId());

					// 获取人员列表
					List<Long> listPerId = new ArrayList<>();
					if (mapList != null && mapList.size() > 0) {
						for (Map map1 : mapList) {
							listPerId.add((Long) map1.get("perId"));
						}
					}
					// 存在排班重复的人员去重
					HashSet hashSet = new HashSet(listPerId);
					listPerId.clear();
					listPerId.addAll(hashSet);

					if (listPerId != null && listPerId.size() > 0) {
						// 固定排班重复人员名称
						listName = validateTaskFixedMapper.listName(listPerId);

					}

					// 移除存在排班重复的人员
					for (int i = 0; i < listPerId.size(); i++) {
						if (implementPerIdList.contains(listPerId.get(i))) {
							implementPerIdList.remove(listPerId.get(i));
						}
					}

					// 任务内部推送列表
					List<ComTaskInsidePush> insertComTaskInsidePushList = new ArrayList<>();

					for (Long perId : implementPerIdList) {
						ComTaskInsidePush comTaskInsidePush = new ComTaskInsidePush();
						ObjectUtils.copyProperties(comTaskInsidePush, comTaskThreeDTO);
						comTaskInsidePush.setInsidePushId(idWorker.nextId());
						comTaskInsidePush.setPerId(perId);
						comTaskInsidePush.setPushPerType("2");
						comTaskInsidePush.setCreateBy(comTaskThreeDTO.getCreateBy());
						comTaskInsidePush.setStartDate(comTask.getStartDate());
						comTaskInsidePush.setEndDate(comTask.getEndDate());
						insertComTaskInsidePushList.add(comTaskInsidePush);
					}

					// 删除之前推送表的人员
					comTaskInsidePushMapper.deleteByComTaskId(comTaskThreeDTO.getComTaskId());

					if (insertComTaskInsidePushList != null && insertComTaskInsidePushList.size() > 0) {

						// 批量插入推送表
						int status3 = comTaskInsidePushMapper.insertComTaskInsidePushList(insertComTaskInsidePushList);

						if (status3 <= 0) {
							throw new BusinessException(Result.ERROR, "任务内部推送失败，请稍后重试");
						}
					}

					// 删除校验表信息
					validateTaskFixedMapper.deleteByPrimaryKey(comTaskThreeDTO.getComTaskId());

					// 删除人员校验表信息
					validateTaskFixedPerMapper.deleteByPrimaryKey(comTaskThreeDTO.getComTaskId());

				} else {
					throw new BusinessException(Result.BUSINESS_ERROR, "固定排班信息不符合要求，请修改后重试");
				}
			}
		}
		Map<String, String> mapConflict = new HashMap<>();

		mapConflict.put("conflict", listName.toString());

		return mapConflict;
	}

	/**
	 * 任务执行情况信息 列表
	 *
	 * @param multiDataDTO
	 * @return
	 */
	@Override
	public Result listTaskImplement(MultiDataDTO multiDataDTO) {

		Map<String, Object> map = new HashMap<>();

		List<MultiDataDTO> list = comTaskImplementMapper.listTaskImplement(multiDataDTO);

		if (list == null) {
			return Result.success(Result.SUCCESS_QUERY_MSG, "");
		}

		// 统计时长
		Long totalTime = 0L;
		// 如果数据不会控
		for (MultiDataDTO mulDto : list) {
			if (StringUtils.isNotEmpty(mulDto.getTimeNode()) && StringUtils.isNotEmpty(mulDto.getDayTrueNode())) {
				// 打卡时间，两个都存在的时候才能去计算时长
				String times[] = mulDto.getTimeNode().split("-");
				String days[] = mulDto.getDayTrueNode().split("#");
				if (times != null && times.length > 1 && days != null && days.length > 1) {
					String startDate = days[0] + " " + times[0];
					String endDate = days[1] + " " + times[1];
					Date dateStart = DateUtil.parseDate(startDate);
					Date dateEnd = DateUtil.parseDate(endDate);
					// 计算出两个日期相差多少分钟
					totalTime = totalTime + DateUtils.getDateSubDateToMinutes(dateStart, dateEnd);
				}
			}

		}
		map.put("list", list);
		map.put("totalTime", totalTime);
		return Result.success("", map);
	}

	/**
	 * 出勤情况列表
	 *
	 * @param multiDataDTO
	 * @return
	 */
	@Override
	public Result listImplement(MultiDataDTO multiDataDTO) {

		List<MultiDataDTO> list = comTaskImplementMapper.listImplement(multiDataDTO);

		// 根据日期分类
		List<MultiDataDTO> listDate = comTaskImplementMapper.listDate(multiDataDTO.getComTaskId());

		// 根据人员分类
		List<MultiDataDTO> listPer = comTaskImplementMapper.listPer(multiDataDTO.getComTaskId());

		// 按人员日期分类
		if (list != null && list.size() > 0) {

			for (MultiDataDTO m1 : listPer) {

				Map<String, List<MultiDataDTO>> map = new HashMap<>();

				for (MultiDataDTO m2 : listDate) {

					List<MultiDataDTO> dateList = new ArrayList<>();

					for (MultiDataDTO m3 : list) {
						if (m3.getPerId().equals(m1.getPerId()) && m3.getDates().equals(m2.getDates())) {
							dateList.add(m3);
						}
					}
					if (dateList != null && dateList.size() > 0) {

						map.put(m2.getDates(), dateList);
					}
				}
				if (map != null && map.size() > 0) {
					m1.setMap(map);
				}
			}
		}
		return Result.success(Result.SUCCESS_QUERY_MSG, listPer);
	}

	/**
	 * 查询任务轨迹最近出勤月份
	 *
	 * @param multiDataDTO
	 * @return
	 */
	@Override
	public Result selectImplementMonth(MultiDataDTO multiDataDTO) {

		String month = comTaskImplementMapper.selectImplementMonth(multiDataDTO.getComTaskId());

		return Result.success(Result.SUCCESS_QUERY_MSG, month);
	}
}