package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.entity.task.ComTaskInsidePush;
import com.bcxin.oa.old.dto.ComTaskDto;
import com.bcxin.oa.old.dto.ComTaskInsidePushDTO;
import com.bcxin.oa.old.dto.ComTaskPerListDTO;
import com.bcxin.oa.old.dto.ComTaskThreeDTO;
import com.bcxin.oa.old.common.CrudDao;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 任务内部推送
 *
 * @author zhangye
 * @since 2018-02-26 10:04:46
 */
public interface ComTaskInsidePushMapper extends CrudDao<ComTaskInsidePush> {

    /**
     * 删除之前的给抄送人员的推送信息
     *
     * @param comTaskId
     * @return
     */
    int deleteByComTaskId(Long comTaskId);

    /**
     * 删除之前的给抄送人员的推送信息，指定人员
     *
     * @param comTaskId
     * @return
     */
    int deleteByTaskIdAndPerId(@Param("comTaskId") Long comTaskId,@Param("perId")Long perId);


    /**
     * 出勤人员
     *
     * @param comTaskId
     * @return
     */
    List<ComTaskInsidePushDTO> listTaskInsidePush1(@Param("comTaskId") Long comTaskId, @Param("comId") Long comId);

    /**
     * 出勤人员（人员详细信息）
     * @param comTaskId
     * @return
     */
    List<Map> listTaskInsidePushDetail(@Param("comTaskId") Long comTaskId,@Param("endDate") String endDate);

    /**
     * 查询任务成员名单
     *
     * @param dto
     * by llc 2018-09-20
     */
    List<Map<String,String>> getTaskPer(ComTaskThreeDTO dto);

    /**
     * 查询任务成员名单
     *
     * @param comTaskId
     * @param comId
     * by llc 2018-09-20
     */
    List<Map<String,String>> getTaskPerNew(@Param("comTaskId") Long comTaskId, @Param("comId") Long comId);



    /**
     * 出勤的部门人员
     *
     * @param comTaskId
     * @param departId
     * @return
     */
    List<ComTaskPerListDTO> listTaskInsidePushAndDepartID(@Param("comTaskId") Long comTaskId, @Param("departId") Long departId, @Param("comId") Long comId);

    /**
     * 出勤人员
     *
     * @param comTaskId
     * @return
     */
    List<String> listPerIdWithType1(Long comTaskId);

    List<String> listValidPerId(@Param("comTaskId") Long comTaskId);

    /**
     * 抄送人员
     *
     * @param comTaskId
     * @return
     */
    List<ComTaskInsidePush> listTaskInsidePush2(Long comTaskId);

    /**
     * 批量插入推送表
     *
     * @param insertComTaskInsidePushList
     * @return
     */
    int insertComTaskInsidePushList(List<ComTaskInsidePush> insertComTaskInsidePushList);


    ComTaskInsidePush getLastPer(@Param("perId")Long perId,@Param("comTaskId") Long comTaskId);


    /**
     * 批量插入代班人员
     * @param comTaskInsidePushList
     * @param createBy
     * @param comId
     * @param comTaskId
     * @param dates
     * @author llc
     * @date 2019-02-21
     */
    int insertBehalfPer(@Param("list") List<ComTaskInsidePush> comTaskInsidePushList,
                        @Param("createBy") Long createBy,
                        @Param("comId") Long comId,
                        @Param("comTaskId") Long comTaskId,
                        @Param("dates") String dates);

    /**
     * 删除任务参与人员
     * @param perIdList
     * @param updateBy
     * @param comTaskId
     * @param date
     * @author llc
     * @date 2019-12-02
     */
    int deleteByTaskIdAndPerIdList(@Param("list") List<String> perIdList,
                                   @Param("updateBy") Long updateBy,
                                   @Param("comTaskId") Long comTaskId,
                                   @Param("date") String date);


    /**
     * 查询目前有效的任务参与人员列表
     *
     * @param comTaskId
     * @param perIdList
     * @author llc
     * @date 2019-12-02
     * @return
     */
    List<String> getTaskPerIdList(@Param("comTaskId") Long comTaskId,@Param("list") List<String> perIdList);


    /**
     * 获取任务排班冲突人员列表
     *
     * @param comTaskId
     * @author llc
     * @date 2020-02-27
     * @return
     */
    List<Map<String,String>> getConflictPerList(@Param("comTaskId") Long comTaskId,@Param("comId") Long comId,@Param("list") List<Long> perIdList);

    /**
     * 修改任务人员的起始日期
     *
     * @param comTaskId
     * @author llc
     * @date 2020-03-05
     * @return
     */
    int updateTaskPerPeriod(@Param("updateBy") Long updateBy,
                             @Param("comTaskId") Long comTaskId,
                             @Param("oldStartDate") Date oldStartDate,
                             @Param("newStartDate") Date newStartDate);


    /**
     * 终止任务修改任务人员的截止日期
     *
     * @param comTaskId
     * @author llc
     * @date 2021-01-06
     * @return
     */
    int endTaskUpdatePerEndDate(@Param("updateBy") Long updateBy,
                                @Param("comTaskId") Long comTaskId,
                                @Param("endDate") Date endDate);



    /**
     * 查询符合延期条件的驻勤人员ID列表
     *
     * @param comTaskId
     * @author llc
     * @date 2021-01-21
     * @return
     */
    List<Long> getExtendTaskPerList(@Param("comId") Long comId,@Param("comTaskId") Long comTaskId,@Param("oldEndDate") Date oldEndDate);


    /**
     * 修改符合延期条件的驻勤人员的终止日期
     *
     * @param updateBy
     * @author llc
     * @date 2021-01-21
     * @return
     */
    int updateTaskPerEndDateByIdList(@Param("updateBy") Long updateBy,
                                     @Param("newEndDate") Date newEndDate,
                                     @Param("list") List<Long> list);


    /**
     * 查询任务成员历史记录
     * @param dto
     * @author llc
     * @date 2020-04-08
     * @return
     */
    List<Map<String,String>> getTaskPerRecord(ComTaskDto dto);
}