package com.bcxin.oa.old.entity.task.tempTask;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 临保任务
 *
 * @author llc
 * @date 2020-02-21
 */
@Data
@TableName("com_temp_task")
public class ComTempTask extends BaseEntity<ComTempTask> {

	/** 临保任务ID */
	@ApiModelProperty(value = "临保任务ID")
	private Long comTempTaskId;

	/** 任务名称 */
	@ApiModelProperty(value = "任务名称")
	private String taskName;

	/** 任务类型 */
	@ApiModelProperty(value = "任务类型")
	private String taskType;

	/** 驻勤点类型 */
	@ApiModelProperty(value = "驻勤点类型")
	private String taskStationType;

	/** 服务对象*/
	@ApiModelProperty(value = "服务对象")
	private String  serviceObject;

	/** 服务对象类型*/
	@ApiModelProperty(value = "服务对象类型")
	private String  serviceObjectType;

	/** 服务对象涉外情况*/
	@ApiModelProperty(value = "服务对象涉外情况")
	private String  serviceObjectSySituation;

	/** 是否治安保卫重点单位*/
	@ApiModelProperty(value = "是否治安保卫重点单位")
	private String  isSecurityImportantUnit;

	/** 任务内容 */
	@ApiModelProperty(value = "任务内容")
	private String taskContent;

	/** 任务地址所在省份 */
	@ApiModelProperty(value = "任务地址所在省份")
	private Integer province;

	/** 任务地址所在城市 */
	@ApiModelProperty(value = "任务地址所在城市")
	private Integer city;

	/** 任务地址所在区县 */
	@ApiModelProperty(value = "任务地址所在区县")
	private Integer area;

	/** 任务地址 */
	@ApiModelProperty(value = "任务地址")
	private String taskAddress;

	/** 任务地址经度 */
	@ApiModelProperty(value = "任务地址经度")
	private String addressLongitude;

	/** 任务地址纬度 */
	@ApiModelProperty(value = "任务地址纬度")
	private String addressLatitude;

	/** 执行范围（单位:米） */
	@ApiModelProperty(value = "执行范围（单位:米）")
	private Long execRange;

	/** 任务状态 */
	@ApiModelProperty(value = "任务状态")
	private String taskStatus;

	/** 任务开始日期 */
	@ApiModelProperty(value = "任务开始日期")
	private Date startDate;

	/** 任务截止日期 */
	@ApiModelProperty(value = "任务截止日期")
	private Date endDate;

	/** 任务负责人ID */
	@ApiModelProperty(value = "任务负责人ID")
	private Long chargePerId;

	/** 合同ID */
	@ApiModelProperty(value = "合同ID")
	private Long comContractId;

	/** 是否关联活动 */
	@ApiModelProperty(value = "是否关联活动")
	private String isRelationActivity;

	/** 活动编号 */
	@ApiModelProperty(value = "活动编号")
	private String activityNo;

	/** 活动名称 */
	@ApiModelProperty(value = "活动名称")
	private String activityName;

	/** 活动企业 */
	@ApiModelProperty(value = "活动企业")
	private String activityCom;

	/** 是否共享任务 */
	@ApiModelProperty(value = "是否共享任务")
	private String isShareTask;

	/**
	 * 所属市公安机构id
	 */
	@ApiModelProperty(value = "所属市公安机构id")
	private Long cityOrgId;

	/**
	 * 所属县（区）机构id
	 */
	@ApiModelProperty(value = "所属县（区）机构id")
	private Long districtOrgId;

	/**
	 * 所属派出所id
	 */
	@ApiModelProperty(value = "所属派出所id")
	private Long policeStationId;

	/**
	 * 百保盾ID
	 */
	@ApiModelProperty(value = "百保盾ID")
	private Long bbdId;

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getComTempTaskId() {
		return comTempTaskId;
	}

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getChargePerId() {
		return chargePerId;
	}

}