package com.bcxin.oa.old.entity.task;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 任务排班制明细
 * 
 * @author zhangye
 * @since 2018-02-26 10:42:16
 */
@Data
@TableName("com_task_schedul")
public class ComTaskSchedul extends BaseEntity<ComTaskSchedul> {
	private static final long serialVersionUID = 937534181L;

	/** 任务排班制ID */
	@ApiModelProperty(value = "任务排班制ID")
	private Long taskSchedulId;

	/** 企业ID */
	@ApiModelProperty(value = "企业ID")
	private Long comId;

	/** 排班日期 */
	@ApiModelProperty(value = "排班日期")
	private Date schedulDate;

	/** 是否休息 */
	@ApiModelProperty(value = "是否休息")
	private String isRest;

	/** 任务ID */
	@ApiModelProperty(value = "任务ID")
	private Long comTaskId;

	/** 排班人员ID */
	@ApiModelProperty(value = "排班人员ID")
	private Long perId;

	/** 班次ID */
	@ApiModelProperty(value = "班次ID")
	private Long shiftId;

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getTaskSchedulId() {
		return taskSchedulId;
	}

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getComTaskId() {
		return comTaskId;
	}

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getPerId() {
		return perId;
	}

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getShiftId() {
		return shiftId;
	}

}