package com.bcxin.oa.old.entity.task;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 任务
 * 
 * @author zhangye
 * @since 2018-02-26 10:42:15
 */
@Data
@TableName("com_task")
public class ComTask extends BaseEntity<ComTask> {
	private static final long serialVersionUID = 1687395452L;

	/** 任务ID */
	@ApiModelProperty(value = "任务ID")
	private Long comTaskId;

	/** 任务名称 */
	@ApiModelProperty(value = "任务名称")
	private String taskName;

	/** 任务类型 */
	@ApiModelProperty(value = "任务类型")
	private String taskType;

	/** 驻勤点类型 */
	@ApiModelProperty(value = "驻勤点类型")
	private String taskStationType;

	/**
	 * 排班制的子排班方式
	 * 规律周期排班和不规律手动排班
	 */
	private String attendSubType;

	/** 任务等级 */
	@ApiModelProperty(value = "任务等级")
	private String taskLevel;

	/** 任务考勤类型 */
	@ApiModelProperty(value = "任务考勤类型")
	private String attendType;

	/** 任务归属 */
	@ApiModelProperty(value = "任务归属")
	private String taskAssign;

	/** 服务类型(以逗号隔开) */
	@ApiModelProperty(value = "服务类型(以逗号隔开)")
	private String serviceType;

	/** 任务性质 */
	@ApiModelProperty(value = "任务性质")
	private String taskNature;

	/** 紧急程度 */
	@ApiModelProperty(value = "紧急程度")
	private String urgentLevel;

	/** 任务内容 */
	@ApiModelProperty(value = "任务内容")
	private String taskContent;

	/** 任务地址所在省份 */
	@ApiModelProperty(value = "任务地址所在省份")
	private Integer province;

	/** 任务地址所在城市 */
	@ApiModelProperty(value = "任务地址所在城市")
	private Integer city;

	/** 任务地址所在区县 */
	@ApiModelProperty(value = "任务地址所在区县")
	private Integer area;

	/** 任务地址 */
	@ApiModelProperty(value = "任务地址")
	private String taskAddress;

	/** 任务地址经度 */
	@ApiModelProperty(value = "任务地址经度")
	private String addressLongitude;

	/** 任务地址纬度 */
	@ApiModelProperty(value = "任务地址纬度")
	private String addressLatitude;

	/** 任务精确地址 */
	@ApiModelProperty(value = "任务精确地址")
	private String taskExactAddress;

	/** 执行范围（单位:米） */
	@ApiModelProperty(value = "执行范围（单位:米）")
	private Long execRange;

	/** 任务状态 */
	@ApiModelProperty(value = "任务状态")
	private String taskStatus;

	/** 任务开始日期 */
	@ApiModelProperty(value = "任务开始日期")
	private Date startDate;

	/** 任务截止日期 */
	@ApiModelProperty(value = "任务截止日期")
	private Date endDate;

	/** 任务时间维度 */
	@ApiModelProperty(value = "任务时间维度")
	private String taskTimeDimension;

//	/** 所需人数 */
//	@ApiModelProperty(value = "所需人数")
//	private Long perNum;

	/** 任务人员投保标记 */
	@ApiModelProperty(value = "任务人员投保标记")
	private String taskInsSign;

	/** 所属项目级别 */
	@ApiModelProperty(value = "所属项目级别")
	private String projectLevel;

	/** 推送范围(情况以，隔开) */
	@ApiModelProperty(value = "推送范围(情况以，隔开)")
	private String pushRange;

	/** 任务实名认证开关(1:开,0:关) */
	@ApiModelProperty(value = "任务实名认证开关(1:开,0:关)")
	private String realNameAuthSwitch;

	/** 参与人员上报开关 */
	@ApiModelProperty(value = "参与人员上报开关")
	private String perReportSwitch;

	/** 任务轨迹上报开关 */
	@ApiModelProperty(value = "任务轨迹上报开关")
	private String locusReportSwitch;

	/** 任务记录考勤开关 */
	@ApiModelProperty(value = "任务记录考勤开关")
	private String recordAttendSwitch;

	/** 任务步数记录开关 */
	@ApiModelProperty(value = "任务步数记录开关")
	private String recordStepSwitch;

	/** 任务负责人ID */
	@ApiModelProperty(value = "任务负责人ID")
	private Long chargePerId;

	/** 所属项目ID */
	@ApiModelProperty(value = "所属项目ID")
	private Long belogProjectId;

	/** 项目ID */
	@ApiModelProperty(value = "项目ID")
	private Long comProjectId;

	/** 服务对象*/
	@ApiModelProperty(value = "服务对象")
	private String  serviceObject;

	/** 服务对象类型*/
	@ApiModelProperty(value = "服务对象类型")
	private String  serviceObjectType;

	/** 服务对象涉外情况*/
	@ApiModelProperty(value = "服务对象涉外情况")
	private String  serviceObjectSySituation;

	/** 是否治安保卫重点单位*/
	@ApiModelProperty(value = "是否治安保卫重点单位")
	private String  isSecurityImportantUnit;


	/**
	 * 所属市公安机构id
	 */
	@ApiModelProperty(value = "所属市公安机构id")
	private Long cityOrgId;

	/**
	 * 所属县（区）机构id
	 */
	@ApiModelProperty(value = "所属县（区）机构id")
	private Long districtOrgId;

	/**
	 * 所属派出所id
	 */
	@ApiModelProperty(value = "所属派出所id")
	private Long policeStationId;

	/**
	 * 百保盾ID
	 */
	@ApiModelProperty(value = "百保盾ID")
	private Long bbdId;

	/**
	 * 合同ID
	 */
	@ApiModelProperty(value = "合同ID")
	private Long comContractId;

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getComTaskId() {
		return comTaskId;
	}

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getExecRange() {
		return execRange;
	}

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getChargePerId() {
		return chargePerId;
	}

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getBelogProjectId() {
		return belogProjectId;
	}

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getComProjectId() {
		return comProjectId;
	}

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getComContractId() {
		return comContractId;
	}

}