package com.bcxin.oa.old.entity.count;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 人员外勤日统计()
 * 
 * @author llc
 * @date 2019-01-15
 */
@Data
@TableName("count_per_task_approve_date")
public class CountPerTaskApproveDate extends BaseEntity<CountPerTaskApproveDate> {
	private static final long serialVersionUID = 1972770399L;

	/** 人员ID */
	@ApiModelProperty(value = "人员ID")
	private Long perId;

	/** 考勤日期 */
	@ApiModelProperty(value = "考勤日期")
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date attendDate;

	/** 任务ID */
	@ApiModelProperty(value = "任务ID")
	private Long comTaskId;

	/** 工作日加班(时) */
	@ApiModelProperty(value = "工作日加班(时)")
	private BigDecimal workDayOverTime;

	/** 休息日加班(时) */
	@ApiModelProperty(value = "休息日加班(时)")
	private BigDecimal restDayOverTime;

	/** 休息日加班(时) */
	@ApiModelProperty(value = "节假日加班(时)")
	private BigDecimal HolidayOverTime;

	/** 事假时长(时) */
	@ApiModelProperty(value = "事假时长(时)")
	private BigDecimal absenceLeaveTime;

	/** 病假时长(时) */
	@ApiModelProperty(value = "病假时长(时)")
	private BigDecimal sickLeaveTime;

	/** 年假时长(时) */
	@ApiModelProperty(value = "年假时长(时)")
	private BigDecimal yearLeaveTime;

	/** 婚假时长(时) */
	@ApiModelProperty(value = "婚假时长(时)")
	private BigDecimal marriageLeaveTime;

	/** 调休时长(时) */
	@ApiModelProperty(value = "调休时长(时)")
	private BigDecimal breakOffTime;

	/** 产假时长(时) */
	@ApiModelProperty(value = "产假时长(时)")
	private BigDecimal maternityLeaveTime;

	/** 公假时长(时) */
	@ApiModelProperty(value = "公假时长(时)")
	private BigDecimal publicLeaveTime;

	/** 主管假时长(时) */
	@ApiModelProperty(value = "主管假时长(时)")
	private BigDecimal chargeLeaveTime;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getPerId() {
		return perId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getComTaskId() {
		return comTaskId;
	}
}