package com.bcxin.oa.old.dto;

import com.bcxin.oa.old.entity.task.ComTask;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 企业任务组固定班制明细DTO
 *
 * @author zhangye
 * @version 1.0
 */
@Data
public class ComTaskThreeDTO extends ComTask {
    /**
     *
     */
    private static final long serialVersionUID = -7117217812684937974L;

    /**
     * 传递任务组固定班制列表
     */
    @ApiModelProperty(value = "推送给内部员工Json")
    private String comTaskInsidePushJson;

    /**
     * 任务组ID
     */
    @ApiModelProperty(value = "任务ID")
    private Long comTaskId;

    @ApiModelProperty(value = "是否发布")
    private String isFB;
    @ApiModelProperty(value = "是否可以暂存")
    private Boolean canZC;

    @ApiModelProperty(value = "公司Id")
    private Long comId;

    @ApiModelProperty(value = "抄送人员ID数组")
    private String[] ccPerId;
    /**
     * json格式 "taskPerJson" : [{"perId":"人员ID","comTaskId":"任务ID","taskPerInsMode":"任务人员投保方式","taskInsSign":"任务人员投保标记"},
     * {"perId":"1","comTaskId":"1","taskPerInsMode":"1","taskInsSign":"1"}]
     */
    @ApiModelProperty(value = "出勤的人员Json")
    private String[] taskPerArray;
    /**
     * 任务人员投保方式 1	个人购买2	企业赠送保险 9	无需投保
     */
    @ApiModelProperty(value = "任务人员投保方式")
    private String taskPerInsMode;

    /**
     * 任务负责人ID
     */
    @ApiModelProperty(value = "任务负责人ID")
    private Long chargePerId;
    /**
     * 任务负责人名称
     */
    @ApiModelProperty(value = "任务负责人名称")
    private String chargePerName;
    /**
     * 部门人员列表
     */
    private List<ComTaskDepartAndPerDTO> departList;
    /**
     * 任务人员详情
     */
    private List<Map> departAndPerList;
    /**
     * 步骤1
     */
    public static String STAGE_ONE = "1";
    /**
     * 步骤2
     */
    public static String STAGE_TWO = "2";
    /**
     * 步骤3
     */
    public static String STAGE_THREE = "3";
    //Yes
    public static String TURE = "1";
    //false
    public static String FALSE = "0";
    //所有都不可以编辑
    public static String ALL_CAN_NOT_EDIT = "0";
    //所有都可编辑
    public static String ALL_CAN_EDIT = "1";
    //一些可以编辑
    public static String SOME_CAN_EDIT = "2";

    /**
     * 关键字
     */
    @ApiModelProperty(value = "关键字")
    private String keyWord;

    /**
     * 资格证持证状态
     */
    @ApiModelProperty(value = "资格证持证状态")
    private String czzt;

}
