package com.bcxin.oa.old.dto;

import com.bcxin.oa.old.entity.task.ComTask;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class ComTaskSchedulDTO extends ComTask {


    @ApiModelProperty(value = "班次Id数组")
    private String[] shiftIdArray;

    /**
     * 任务排班周期Json
     * <p>
     * "comTaskSchedulCycleJson":[{"cycleName":"周期名称AAA","cycleDays":"4","shiftIdArrayUse":[1,2,3,-1]},{"cycleName":"周期名称BBB","cycleDays":"4","shiftIdArrayUse":[1,2,3,-1]}]
     */
    @ApiModelProperty(value = "任务排班周期Json")
    private String comTaskSchedulCycleJson;


    /**
     * 出勤地点Json
     * <p>
     * "comTaskAttendAddressJson" :[{"addressRange":"考勤范围（米为单位）","address":"考勤地址","addressLongitude":"考勤地址经度","addressLatitude":"考勤地址纬度"}]
     */
    @ApiModelProperty(value = "出勤地点Json")
    private String comTaskAttendAddressJson;

    @ApiModelProperty(value = "公司Id")
    private Long comId;


    @JsonSerialize(using = ToStringSerializer.class)
    public Long getComId() {
        return comId;
    }
}
