package com.bcxin.oa.old.dto;

import com.bcxin.oa.old.common.BaseEntity;
import com.bcxin.oa.old.entity.task.ComTaskAttendAddress;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 企业任务组固定班制明细DTO
 * 
 * @author zhangye
 * @version 1.0
 */
public class ComTaskFixedTempDTO extends BaseEntity {
	/**
	 *
	 */
	private static final long serialVersionUID = -7117217812684937974L;
	/** 传递任务出勤地点列表 */
	@ApiModelProperty(value = "任务出勤地点列表")
	private String comTaskAttendAdresses;
	/** 传递任务组固定班制列表 */
	@ApiModelProperty(value = "任务固定班制列表")
	private String comTaskFixeds;
	/** 任务组ID */
	@ApiModelProperty(value = "任务ID")
	private Long comTaskId;
	/** 考勤类型(1：固定班制，2：排班制，3：自由工时) */
	@ApiModelProperty(value = "考勤类型")
	private String attendType;
	/** 返回任务固定班制列表 */
	private List<ComTaskFixedDTO> returnComTaskFixedDList;
	/** 返回任务考勤地点列表 */
	private List<ComTaskAttendAddress> returnComTaskAttendAddressList;

	public String getComTaskFixeds() {
		return comTaskFixeds;
	}

	public void setComTaskFixeds(String comTaskFixeds) {
		this.comTaskFixeds = comTaskFixeds;
	}
	@JsonSerialize(using = ToStringSerializer.class)
	public Long getComTaskId() {
		return comTaskId;
	}

	public void setComTaskId(Long comTaskId) {
		this.comTaskId = comTaskId;
	}

	public String getAttendType() {
		return attendType;
	}

	public void setAttendType(String attendType) {
		this.attendType = attendType;
	}

	public List<ComTaskFixedDTO> getReturnComTaskFixedDList() {
		return returnComTaskFixedDList;
	}

	public void setReturnComTaskFixedDList(List<ComTaskFixedDTO> returnComTaskFixedDList) {
		this.returnComTaskFixedDList = returnComTaskFixedDList;
	}

	public List<ComTaskAttendAddress> getReturnComTaskAttendAddressList() {
		return returnComTaskAttendAddressList;
	}

	public void setReturnComTaskAttendAddressList(List<ComTaskAttendAddress> returnComTaskAttendAddressList) {
		this.returnComTaskAttendAddressList = returnComTaskAttendAddressList;
	}

	public String getComTaskAttendAdresses() {
		return comTaskAttendAdresses;
	}

	public void setComTaskAttendAdresses(String comTaskAttendAdresses) {
		this.comTaskAttendAdresses = comTaskAttendAdresses;
	}
}
