package com.bcxin.oa.old.dto;


import com.bcxin.oa.old.entity.task.ComAttendGroup;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author zhangjianhua
 * @date 2018/02/26
 */
@Data
public class ComAttendGroupDTO extends ComAttendGroup {

    /**
     * 企业考勤组考勤人员（逗号隔开的字符串）
     */
    @ApiModelProperty(value = "企业考勤组考勤人员")
    private String perIdStr;

    /**
     * 企业考勤组负责人员（逗号隔开的字符串）
     */
    @ApiModelProperty(value = "企业考勤组负责人员")
    private String chargePerIdStr;
    /**
     * 考勤类型名称
     */
    private String attendTypeName;
    /**
     * 考勤组信息
     */
    private String comAttendGroupMessage;


    /** 考勤中间表ID */
    @ApiModelProperty(value = "考勤中间表ID")
    private Long midAttendGroupId;


    /** 是否调整考勤组人员 */
    @ApiModelProperty(value = "是否调整考勤组人员")
    private String isAdjust;

    /** 考勤组 */
    @ApiModelProperty(value = "考勤组固定班制列表")
    private String comAttendGroupFixeds;

    /** 是否新增进入 **/
    @ApiModelProperty(value = "是否新增进入")
    private String isAdd;

    /** 是否正式考勤 **/
    @ApiModelProperty(value = "是否正式考勤")
    private String isFormal;

    /**
     * 人数
     */
    private String perCount;

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getMidAttendGroupId() {
        return midAttendGroupId;
    }



}
