package com.bcxin.oa.current.ascept;

import com.bcxin.oa.current.common.utils.AssertUtils;
import com.bcxin.oa.current.common.utils.TokenUtils;
import com.bcxin.oa.old.entity.system.PerOrgRelation;
import com.bcxin.oa.old.service.system.PerOrgRelationService;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;

/**
 * description：鉴权切面
 * author：linchunpeng
 * date：2023/11/7
 */
@Slf4j
@Component
@Aspect
public class AuthAspect {

    @Resource
    private PerOrgRelationService perOrgRelationService;

    /**
     * 路径校验器
     */
    private final AntPathMatcher antPathMatcher =  new AntPathMatcher();

    /**
     * description：环绕切面
     * author：linchunpeng
     * date：2023/11/15
     */
    @Around("execution(* com.bcxin.oa.*.controller..*.*(..))")
    public Object doAround(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes) requestAttributes;
        HttpServletRequest request = servletRequestAttributes.getRequest();

        if(this.isMatch(request.getRequestURI(), getPublicUris())) {
            return proceedingJoinPoint.proceed(proceedingJoinPoint.getArgs());
        }
        //取出授权信息
        String accesstoken = TokenUtils.getBcxToken(request);
        AssertUtils.isNotEmptyString(accesstoken, "Accesstoken不能为空");

        String employeeId = TokenUtils.getEmployeeIdFromBcxToken(accesstoken);
        AssertUtils.isNotEmptyString(employeeId, "无效的Accesstoken");

        PerOrgRelation perOrgRelation = perOrgRelationService.getByTlkId(employeeId);
        AssertUtils.isNotNullObject(perOrgRelation, "用户不存在");

        request.setAttribute("comId", perOrgRelation.getComId());
        request.setAttribute("perId", perOrgRelation.getPerId());

        Object[] args = proceedingJoinPoint.getArgs();
        for (Object obj : args) {
            Class clazz = obj.getClass();
            while (clazz != null) {
                Field[] fields = clazz.getDeclaredFields();
                if (fields != null && fields.length > 0) {
                    for (Field item : fields) {
                        if (item.getName().equals("comId")) {
                            if (perOrgRelation.getComId() != null) {
                                if (item.getGenericType().toString().equals("class java.lang.Long")) {
                                    item.setAccessible(true);
                                    try {
                                        item.set(obj, perOrgRelation.getComId());
                                    } catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                        }
                    }
                }
                clazz = clazz.getSuperclass();
            }
        }

        Object proceed = proceedingJoinPoint.proceed(proceedingJoinPoint.getArgs());
//        log.info("职员id：{}，请求地址：{}，返回参数：{}", employeeId, request.getRequestURI(), JSONObject.toJSONString(proceed));
        return proceed;
    }

    /**
     * description：实付匹配
     * author：linchunpeng
     * date：2023/11/15
     */
    private boolean isMatch(String url, List<String> uris) {
        if(uris==null){
            return false;
        }
        for (String uri : uris) {
            if (this.antPathMatcher.match(uri, url)) {
                return true;
            }
        }
        return false;
    }

    /**
     * description：不需要鉴权的接口url
     * author：linchunpeng
     * date：2023/11/15
     */
    private List<String> getPublicUris() {
        return Arrays.asList("/zidingyi", "/zidingyi2");
    }
}
