package com.bcxin.oa.old.service.task.app;

import com.bcxin.oa.old.common.CommonConst;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.utils.BBDService;
import com.bcxin.oa.old.dto.app.AppComTaskImplementDto;
import com.bcxin.oa.old.entity.task.ComTask;
import com.bcxin.oa.old.entity.task.ComTaskImplement;
import com.bcxin.oa.old.mapper.ComTaskImplementMapper;
import com.bcxin.oa.old.mapper.ComTaskMapper;
import com.bcxin.oa.old.service.common.CommonService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

/**
 * APP任务轨迹管理
 *
 * @author zhangye
 * @since 2018-03-16 10:47:41
 */
@Service
@Transactional
public class AppComTaskTrackServiceImpl implements AppComTaskTrackService {

	@Resource
	private ComTaskMapper comTaskMapper;
	@Resource
	private CommonService commonService;
	@Resource
	private ComTaskImplementMapper comTaskImplementMapper;

	@Override
	public Result listTaskTrack(AppComTaskImplementDto appComTaskImplementDto) throws BusinessException {
		if (appComTaskImplementDto.getTaskImplementId() == null) {
			throw new BusinessException(Result.BUSINESS_ERROR, "任务执行情况Id不能为空");
		}
		ComTaskImplement comTaskImplement = comTaskImplementMapper
				.getByPrimaryKey(appComTaskImplementDto.getTaskImplementId());
		if (comTaskImplement == null) {
			throw new BusinessException(Result.BUSINESS_ERROR, "查询任务轨迹失败，轮次执行情况不存在");
		}
		ComTask comTask = comTaskMapper.getComTaskByPrimaryKey(comTaskImplement.getComTaskId());
		try {
			String open_substation = commonService.getSystemConfig(CommonConst.OPEN_SUBSTATION);// 是否开启陕西子站地址默认站点(0：未开启,1：开启)
			String configURL = ""; // 公安子站服务器地址
			if (StringUtils.isNotEmpty(open_substation) && open_substation.equals(CommonConst.Y)) {
				configURL = commonService.getSystemConfig(CommonConst.TRACK_ + "DEFAULT");
			} else {
				configURL = commonService.getSystemConfig(CommonConst.TRACK_ + comTask.getProvince());
			}
			// 任务归属城市，未开通（未落地部署），进入任务轨迹界面，应提示：任务所属城市暂未开放轨迹服务
			if (StringUtils.isEmpty(configURL)) {
				throw new BusinessException(Result.BUSINESS_ERROR, "任务所属城市暂未开放轨迹服务");
			} else {
				Result postResult = BBDService.listTaskTrack(appComTaskImplementDto.getTaskImplementId().toString(),
						appComTaskImplementDto.getSessionId(), configURL);
				if (postResult.getRetType().equals(Result.ERROR)) {
					throw new BusinessException(Result.BUSINESS_ERROR, "查询任务轨迹失败，请稍后重试");
				} else {
					return postResult;
				}
			}
		} catch (Exception e) {
			throw new BusinessException(Result.BUSINESS_ERROR, "查询任务轨迹失败，请稍后重试");
		}
	}

	@Override
	public Result saveTaskTrack(AppComTaskImplementDto appComTaskImplementDto) throws BusinessException {
		if (appComTaskImplementDto.getTaskImplementId() == null) {
			throw new BusinessException(Result.BUSINESS_ERROR, "任务执行情况Id不能为空");
		}
		if (StringUtils.isEmpty(appComTaskImplementDto.getAddressLongitude())) {
			throw new BusinessException(Result.BUSINESS_ERROR, "经度不能为空");
		}
		if (StringUtils.isEmpty(appComTaskImplementDto.getAddressLatitude())) {
			throw new BusinessException(Result.BUSINESS_ERROR, "纬度不能为空");
		}
		ComTaskImplement comTaskImplement = comTaskImplementMapper
				.getByPrimaryKey(appComTaskImplementDto.getTaskImplementId());
		if (comTaskImplement == null) {
			throw new BusinessException(Result.BUSINESS_ERROR, "保存任务轨迹失败，轮次执行情况不存在");
		}
		ComTask comTask = comTaskMapper.getComTaskByPrimaryKey(comTaskImplement.getComTaskId());
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("taskFeedbackId", appComTaskImplementDto.getTaskImplementId());// 任务执行情况Id
		paramMap.put("longitude", appComTaskImplementDto.getAddressLongitude()); // 经度
		paramMap.put("latitude", appComTaskImplementDto.getAddressLatitude()); // 纬度
		paramMap.put("personId", comTaskImplement.getPerId()); // 人员ID
		try {
			String open_substation = commonService.getSystemConfig(CommonConst.OPEN_SUBSTATION);// 是否开启陕西子站地址默认站点(0：未开启,1：开启)
			String configURL = ""; // 公安子站服务器地址
			if (StringUtils.isNotEmpty(open_substation) && open_substation.equals(CommonConst.Y)) {
				configURL = commonService.getSystemConfig(CommonConst.TRACK_ + "DEFAULT");
			} else {
				configURL = commonService.getSystemConfig(CommonConst.TRACK_ + comTask.getProvince());
			}
			// 任务归属城市，未开通（未落地部署），进入任务轨迹界面，应提示：任务所属城市暂未开放轨迹服务
			if (StringUtils.isEmpty(configURL)) {
				throw new BusinessException(Result.BUSINESS_ERROR, "任务所属城市暂未开放轨迹服务");
			} else {
				Result postResult = BBDService.saveTaskTrack(paramMap, configURL);
				if (postResult.getRetType().equals(Result.ERROR)) {
					throw new BusinessException(Result.BUSINESS_ERROR, "保存任务轨迹失败，请稍后重试");
				} else {
					return postResult;
				}
			}
		} catch (Exception e) {
			throw new BusinessException(Result.BUSINESS_ERROR, "保存任务轨迹失败，请稍后重试");
		}
	}

	@Override
	public Result checkTaskTrack(AppComTaskImplementDto appComTaskImplementDto) throws BusinessException {
		ComTaskImplement comTaskImplement = comTaskImplementMapper
				.getByPrimaryKey(appComTaskImplementDto.getTaskImplementId());
		if (appComTaskImplementDto.getTaskImplementId() == null) {
			throw new BusinessException(Result.BUSINESS_ERROR, "任务执行情况Id不能为空");
		}
		try {
			ComTask comTask = comTaskMapper.getComTaskByPrimaryKey(comTaskImplement.getComTaskId());
			String open_substation = commonService.getSystemConfig(CommonConst.OPEN_SUBSTATION);// 是否开启陕西子站地址默认站点(0：未开启,1：开启)
			String configURL = ""; // 公安子站服务器地址
			if (StringUtils.isNotEmpty(open_substation) && open_substation.equals(CommonConst.Y)) {
				configURL = commonService.getSystemConfig(CommonConst.TRACK_ + "DEFAULT");
			} else {
				configURL = commonService.getSystemConfig(CommonConst.TRACK_ + comTask.getProvince());
			}
			// 任务归属城市，未开通（未落地部署），进入任务轨迹界面，应提示：任务所属城市暂未开放轨迹服务
			if (StringUtils.isEmpty(configURL)) {
				return Result.fail("任务所属城市暂未开放轨迹服务");
			} else {
				return Result.success("任务所属城市已开放轨迹服务");
			}
		} catch (Exception e) {
			throw new BusinessException(Result.BUSINESS_ERROR, "检查所属城市任务轨迹失败，请稍后重试");
		}
	}
}