package com.bcxin.oa.old.service.system;

import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.dto.PerBaseInfoDto;
import com.bcxin.oa.old.dto.PerInfoQueryDto;
import com.bcxin.oa.old.dto.PerOrgRelationDto;
import com.bcxin.oa.old.dto.PerTaskInfoDto;
import com.bcxin.oa.old.entity.system.PerBaseInfo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 人员基础信息
 *
 * @author zhangye
 * @since 2017-12-25 17:11:16
 */
public interface PerBaseInfoService {

	/**
	 * @Author: wangcy
	 * @Description:查看用户基础信息
	 * @Date: 2017/12/27 0027 19:10
	 */
	Result getPerBaseInfo(Long perBaseInfoId);

	/**
	 * 查看用户入职信息
	 * @param perBaseInfo
	 * @return
	 */
	Result getPerWorkInfo(PerBaseInfo perBaseInfo);


	/**
	 * 通过人员ID列表查询人员基础信息
	 *
	 * @param dto
	 * @return
	 * @author llc
	 * @date 2020-04-15
	 */
	Result getPerBaseInfoListByPerIds(PerBaseInfoDto dto);

	/**
	 * 通过人员ID查询人员基础信息
	 *
	 * @param perId
	 * @return
	 * @author llc
	 * @date 2020-05-21
	 */
	Result getPerBaseInfoByPerId(Long perId);

	Result getSimplePerBaseInfo(Long perBaseInfoId);

	Result getSimplePerBaseInfo(String idCardNo);

	Result getPerDepartInfoByIdList(Map<String , Object> paranMap);

	/**
	 * @Author: wangjianchi
	 * @Description:查看用户基础信息
	 * @Date: 2018/04/24 0027 16:10
	 */
	Result getPerAllInfo(Long perId);

	/**
	 * @Author: zhongjianhui
	 * @Description:查询离职人员
	 * @Date: 2017/12/29 17:47
	 */
	Result pageForLeavePer(PerOrgRelationDto perOrgRelationDto);

	/**
	 * 人员信息分页查询
	 *
	 * @param dto
	 * @return
	 * @author llc
	 * @date 2019-05-17
	 */
	Result pageForPerInfo(PerInfoQueryDto dto);

	/**
	 * 导出保安人员信息
	 * @param dto
	 * @author llc
	 * @date 2019-06-03
	 */
	Result exportSecurityStaffInfo(PerInfoQueryDto dto, HttpServletResponse response);


	/**
	 * 保安人员驻勤点信息分页查询
	 *
	 * @param dto
	 * @return
	 * @author llc
	 * @date 2020-04-22
	 */
	Result pagePerTaskInfo(PerTaskInfoDto dto);


	/**
	 * 导出人员驻勤点信息
	 * @param dto
	 * @author llc
	 * @date 2020-04-23
	 */
	Result exportPerTaskInfo(PerTaskInfoDto dto, HttpServletResponse response);


	/**
	 * <b> 批量查询用户是否存在 </b>
	 * @author hzh
	 * @create 2020/10/29
	 */
	Result batchCheckPerson(List<String> list);


	/**
	 * 获取用户定位信息
	 * @param perId
	 * @return
	 */
    Result getPerLocation(Long perId);

	/**
	 * 获得用户在职信息
	 * @param perId
	 * @return
	 */
	Result getPerWork(Long perId);
}