package com.bcxin.oa.old.service.attend;

import com.bcxin.oa.old.mapper.ComAttendPerMapper;
import com.bcxin.oa.old.dto.ComAttendPerDTO;
import com.bcxin.oa.old.common.Result;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 企业考勤组考勤人员
 *
 * @author zhangye
 * @since 2018-02-26 10:47:41
 */
@Service
@Transactional
public class ComAttendPerServiceImpl implements ComAttendPerService {
	@Resource
	private ComAttendPerMapper comAttendPerMapper;

	/**
	 * 检查人员是否存在于其他考勤组
	 *
	 * @param comAttendPerDTO
	 * @return
	 */
	@Override
	public Result findAttendGroupByPerId(ComAttendPerDTO comAttendPerDTO) {

		ComAttendPerDTO comAttendPer = comAttendPerMapper.findAttendGroupByPerId(comAttendPerDTO);

		if (comAttendPer != null) {
			return Result.success("", comAttendPer);
		} else {
			return Result.success("", false);
		}
	}

	/**
	 * 检查多个人员是否存在于其他考勤组
	 *
	 * @param comAttendPerDTO
	 * @return
	 */
	@Override
	public Result findAttendGroupByPerIdStr(ComAttendPerDTO comAttendPerDTO) {

		List<ComAttendPerDTO> list = new ArrayList<>();

		if (StringUtils.isNotEmpty(comAttendPerDTO.getPerIdStr())) {

			String[] perIdArray = comAttendPerDTO.getPerIdStr().split(",");
			for (String perId : perIdArray) {

				comAttendPerDTO.setPerId(Long.parseLong(perId));

				ComAttendPerDTO comAttendPer = comAttendPerMapper.findAttendGroupByPerId(comAttendPerDTO);

				if (comAttendPer != null) {
					list.add(comAttendPer);
				}
			}
		}
		return Result.success("", list);
	}
}