package com.bcxin.oa.old.mapper.salary;


import com.bcxin.oa.old.entity.salary.ComSalaryTempProject;
import com.bcxin.oa.old.dto.salary.ComSalaryTempProjectDTO;
import org.apache.ibatis.annotations.Param;

import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * 企业薪酬模板对应项目
 *
 * @author llc
 * @date 2018-12-28
 */
public interface ComSalaryTempProjectMapper{


    /**
     * 插入企业薪酬对应项目
     * @author llc
     * @date 2018-12-28
     * @param list
     * @return
     */
    int batchInsertSalaryTempProject(@Param("list") Collection<ComSalaryTempProject> list);


    /**
     * 删除企业薪酬对应项目
     * @author llc
     * @date 2018-12-29
     * @param comSalaryTempId
     * @return
     */
    int deleteSalaryTempProject(@Param("comSalaryTempId") Long comSalaryTempId);


    /**
     * 查询企业薪酬对应项目
     * @author llc
     * @date 2018-12-29
     * @param comSalaryTempId
     * @return
     */
    List<ComSalaryTempProjectDTO> getComSalaryTempProjectList(@Param("comSalaryTempId") Long comSalaryTempId);


    /**
     * 复制企业薪酬模板对应项目
     * @author llc
     * @date 2018-12-29
     * @param oldComSalaryTempId  旧的薪酬模板ID
     * @param newComSalaryTempId  新的薪酬模板ID
     * @param createBy  创建者
     * @param createTime  创建时间
     * @return
     */
    int copySalaryTempProject(@Param("oldComSalaryTempId") Long oldComSalaryTempId,
                              @Param("newComSalaryTempId") Long newComSalaryTempId,
                              @Param("createBy") Long createBy,
                              @Param("createTime") Date createTime);

}