package com.bcxin.oa.old.mapper.app;

import com.bcxin.oa.old.dto.app.AppComAttendDTO;
import com.bcxin.oa.old.dto.app.AppComAttendShiftDTO;
import com.bcxin.oa.old.dto.app.AppComAttendSmallShiftDTO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * APP企业考勤列表
 *
 * @author zhangye
 * @since 2018-02-26 10:23:07
 */
public interface ComAttendMapper {

	/**
	 * 考勤信息
	 * 
	 * @param appComAttendDTO
	 * @return
	 */
	AppComAttendDTO getComAttend(AppComAttendDTO appComAttendDTO);

	/**
	 * 获取考勤班次列表
	 * 
	 * @param appComAttendDTO
	 * @return
	 */
	List<AppComAttendShiftDTO> getComAttendShiftList(AppComAttendDTO appComAttendDTO);

	/**
	 * 获取考勤轮次列表
	 * 
	 * @param appComAttendShiftDTO
	 * @return
	 */
	List<AppComAttendSmallShiftDTO> getComAttendSmallShiftList(AppComAttendShiftDTO appComAttendShiftDTO);

	String getIsActive(@Param("comId") Long comId, @Param("approveType") String approveType);
}