package com.bcxin.oa.old.entity.task;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 企业考勤组
 * 
 * @author zhangye
 * @since 2018-02-26 10:23:07
 */
@TableName("com_attend_group")
@Data
public class ComAttendGroup extends BaseEntity<ComAttendGroup> {
	private static final long serialVersionUID = 1239397319L;

	/** 考勤组ID */
	@ApiModelProperty(value = "考勤组ID")
	private Long attendGroupId;

	/** 考勤组名称 */
	@ApiModelProperty(value = "考勤组名称")
	private String attendGroupName;

	/** 生效规则 */
	@ApiModelProperty(value = "生效规则")
	private String effectRule;

	/** 生效开始时间 */
	@ApiModelProperty(value = "生效开始时间")
	private Date effectStartTime;

	/** 生效截止时间 */
	@ApiModelProperty(value = "生效截止时间")
	private Date effectEndTime;

	/** 考勤类型(1：固定班制，2：排班制，3：自由工时) */
	@ApiModelProperty(value = "考勤类型")
	private String attendType;

	/** 是否遵循法定假日 */
	@ApiModelProperty(value = "是否遵循法定假日")
	private String isFollowLegalHoliday;

	/** 班次ID集合 */
	@ApiModelProperty(value = "班次ID集合")
	private String shiftIds;

	/** 班次详情集合 */
	@ApiModelProperty(value = "班次详情集合")
	private String shiftDetails;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getAttendGroupId() {
		return attendGroupId;
	}
}