package com.bcxin.oa.old.entity.system;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @author：wangcy @date：2017/12/20 0020 10:06
 * @description：PerBaseInfo的实体类
 */
@TableName("per_base_info")
@Data
public class PerBaseInfo extends BaseEntity<PerBaseInfo> {
	/**
	 * 人员ID
	 */
	@ApiModelProperty(value = "人员ID")
	@NotNull(message = "人员ID不能为空")
	private Long perId;

	/**
	 * 行业类型
	 */
	@ApiModelProperty(value = "行业类型")
	private String industryType;
	/**
	 * 机构类型
	 */
	@ApiModelProperty(value = "机构类型")
	private String institutionType;

	/**
	 * 人脸识别认证状态
	 */
	@ApiModelProperty(value = "人脸识别认证状态")
	private String authStatus;

	/**
	 * 身份证件类型
	 */
	@ApiModelProperty(value = "身份证件类型")
	private String idCardType;
	/**
	 * 证件号码
	 */
	@ApiModelProperty(value = "证件号码")
	private String idCardNo;
	/**
	 * 姓名
	 */
	@ApiModelProperty(value = "姓名")
	private String name;
	/**
	 * 是否在职
	 */
	@ApiModelProperty(value = "是否在职")
	private String isIncumbency;
	/**
	 * 头像存放url
	 */
	@ApiModelProperty(value = "头像存放url")
	private String photoUrl;

	/**
	 * 一寸免冠彩照url
	 */
	@ApiModelProperty(value = "一寸免冠彩照url")
	private String colourPhotoUrl;

	/**
	 * 一寸免冠彩照url(企业上传)
	 */
	@ApiModelProperty(value = "一寸免冠彩照url(企业上传)")
	private String oneInchColourPhotoUrl;

	/**
	 * 两寸免冠彩照url
	 */
	@ApiModelProperty(value = "两寸免冠彩照url")
	private String twoInchColourPhotoUrl;


	/**
	 * 身份证正面url
	 */
	@ApiModelProperty(value = "身份证正面url")
	private String idCardFrontUrl;

	/**
	 * 身份证反面url
	 */
	@ApiModelProperty(value = "身份证反面url")
	private String idCardReverseUrl;

	/**
	 * 性别
	 */
	@ApiModelProperty(value = "性别")
	private String sex;
	/**
	 * 民族
	 */
	@ApiModelProperty(value = "民族")
	private String nation;
	/**
	 * 出生日期
	 */
	@ApiModelProperty(value = "出生日期")
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date birthday;
	/**
	 * 参加工作日期
	 */
	@ApiModelProperty(value = "参加工作日期")
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date firstWorkDay;
	/**
	 * 人员类型
	 */
	@ApiModelProperty(value = "人员类型")
	private String perType;
	/**
	 * 国籍
	 */
	@ApiModelProperty(value = "国籍")
	private String nationality;
	/**
	 * 籍贯
	 */
	@ApiModelProperty(value = "籍贯")
	private String originPlace;
	/**
	 * 学历
	 */
	@ApiModelProperty(value = "学历")
	private String education;
	/**
	 * 手机号
	 */
	@ApiModelProperty(value = "手机号")
	private String mobilePhone;
	/**
	 * 电子邮箱
	 */
	@ApiModelProperty(value = "电子邮箱")
	private String email;
	/**
	 * 身高
	 */
	@ApiModelProperty(value = "身高")
	private int height;
	/**
	 * 血型
	 */
	@ApiModelProperty(value = "血型")
	private String bloodType;
	/**
	 * 政治面貌
	 */
	@ApiModelProperty(value = "政治面貌")
	private String politicalStatus;
	/**
	 * 婚姻状况
	 */
	@ApiModelProperty(value = "婚姻状况")
	private String maritalStatus;
	/**
	 * 户籍类型
	 */
	@ApiModelProperty(value = "户籍类型")
	private String residentType;

	/**
	 * 驾照等级
	 */
	@ApiModelProperty(value = "驾照等级")
	private String drivingLicenseLevel;

	/**
	 * 户口所在省
	 */
	@ApiModelProperty(value = "户口所在省")
	private Integer residentProvince;
	/**
	 * 户口所在城市
	 */
	@ApiModelProperty(value = "户口所在城市")
	private Integer residentCity;
	/**
	 * 户口所在区/县
	 */
	@ApiModelProperty(value = "户口所在区/县")
	private Integer residentArea;
	/**
	 * 户口具体地址
	 */
	@ApiModelProperty(value = "户口具体地址")
	private String residenceAddress;

	/**
	 * 居住地所在省
	 */
	@ApiModelProperty(value = "居住地所在省")
	private Integer domicileProvince;
	/**
	 * 居住地所在城市
	 */
	@ApiModelProperty(value = "居住地所在城市")
	private Integer domicileCity;
	/**
	 * 居住地所在区/县
	 */
	@ApiModelProperty(value = "居住地所在区/县")
	private Integer domicileArea;
	/**
	 * 居住具体地址
	 */
	@ApiModelProperty(value = "居住具体地址")
	private String domicileAddress;
	/**
	 * 紧急联系人
	 */
	@ApiModelProperty(value = "紧急联系人")
	private String contactper;
	/**
	 * 联系人手机号码
	 */
	@ApiModelProperty(value = "联系人手机号码")
	private String contactPhone;
	/**
	 * 数据来源
	 */
	@ApiModelProperty(value = "数据来源")
	private String perSource;
	/**
	 * 备注
	 */
	@ApiModelProperty(value = "备注")
	private String remark;
	/**
	 * 人员注册事件ID
	 */
	@ApiModelProperty(value = "人员注册事件ID")
	private Long perRegEventId;
	/**
	 * 人员新增事件ID
	 */
	@ApiModelProperty(value = "人员新增事件ID")
	private Long perAddEventId;

	@ApiModelProperty(value = "天翎人员id")
	private String tlkUserId;


	@JsonSerialize(using = ToStringSerializer.class)
	public Long getPerId() {
		return perId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getPerRegEventId() {
		return perRegEventId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getPerAddEventId() {
		return perAddEventId;
	}

}
