package com.bcxin.oa.old.dto.app;

import com.bcxin.oa.old.entity.task.PerTaskCardRecord;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 任务考勤打卡记录DTO
 *
 * @author wangjianchi
 * @version 1.0
 */
@Data
public class AppPerTaskCardRecordDTO extends PerTaskCardRecord {

	@ApiModelProperty(value = "任务执行情况ID")
	private Long taskImplementId;

	/**
	 * 任务反馈记录ID
	 */
	@ApiModelProperty(value = "任务反馈记录ID")
	private Long taskFeedbackId;

	/**
	 * 任务反馈内容
	 */
	@ApiModelProperty(value = "任务反馈内容")
	private String feedbackContent;

	/**
	 * 反馈图片url
	 */
	@ApiModelProperty(value = "反馈图片url")
	private String imageUrl;

	/**
	 * 值班状态（1正常2离岗）
	 */
	@ApiModelProperty(value = "值班状态")
	private String dutyState;

	/**
	 * 离岗原因类别（1执行紧急任务2提前完成任务3请假4其他）
	 */
	@ApiModelProperty(value = "离岗原因类别")
	private String leaveType;

	/**
	 * 离岗原因
	 */
	@ApiModelProperty(value = "离岗原因")
	private String leaveComment;
	/**
	 * 反馈人员ID
	 */
	@ApiModelProperty(value = "反馈人员ID")
	private Long feedbackPerId;

	@ApiModelProperty(value = "公司Id")
	private Long comId;

}
