package com.bcxin.oa.old.dto.app;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * APP任务班次
 * 
 * @author zhangye
 *
 */
@Data
public class AppComTaskShiftDTO {

	/**
	 * 班次ID
	 */
	@ApiModelProperty(value = "班次ID")
	private Long shiftId;
	/**
	 * 任务组ID
	 */
	@ApiModelProperty(value = "任务组ID")
	private Long attendGroupId;

	/**
	 * 班次状态 (1：未开始，2：可上班打卡，3：可下班打卡，4：已结束)
	 */
	@ApiModelProperty(value = "班次状态")
	private int currentShiftType;
	/**
	 * 班次类别(1：周期排班制班，2：周期固定班，3：临时班，4：紧急班，5：自由班)
	 */
	@ApiModelProperty(value = "班次类别")
	private int shiftType;
	/**
	 * 班次名称
	 */
	@ApiModelProperty(value = "班次名称")
	private String shiftName;

	/**
	 * 任务日期
	 */
	@ApiModelProperty(value = "班次开始日期")
	private Date dates;

	/**
	 * 班次时间
	 */
	@ApiModelProperty(value = "班次时间")
	private String shiftTime;

	/**
	 * 班次是几号
	 */
	@ApiModelProperty(value = "班次是几号")
	private int day;

	/**
	 * 当前打卡状态是否为早退（用在下班打卡是否填写离岗说明）
	 */
	@ApiModelProperty(value = "当前打卡状态是否为早退")
	private boolean dutyStatus;

	/**
	 * 班次日期
	 */
	@ApiModelProperty(value = "班次日期")
	private String shiftDate;
	/**
	 * 人员ID
	 */
	@ApiModelProperty(value = "人员ID")
	private Long perId;
	/**
	 * 任务轮次列表
	 */
	@ApiModelProperty(value = "任务轮次列表")
	private List<AppComTaskSmallShiftDTO> arrSmallShifts = new ArrayList<AppComTaskSmallShiftDTO>();

	/**
	 * 已执行时长
	 */
	@ApiModelProperty(value = "已执行时长")
	private String tip;

	/**
	 * 倒计时时长(已执行)
	 */
	@ApiModelProperty(value = "倒计时时长(已执行)")
	private String countDown;

	/**
	 * 补卡项状态0：停用，1：启用
	 */
	@ApiModelProperty(value = "补卡项状态")
	private int isActive;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getShiftId() {
		return shiftId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getPerId() {
		return perId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getAttendGroupId() {
		return attendGroupId;
	}

}
