package com.bcxin.oa.old.dto.app;

import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 *
 * APP任务
 *
 * @author zhangye
 * @since 2018-03-15 16:24:22
 */
@Data
public class AppComTaskDTO extends BaseEntity<AppComTaskDTO> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 49195933494526696L;
	/** 任务ID */
	@ApiModelProperty(value = "任务ID")
	private Long taskId;
	/** 任务类型 */
	@ApiModelProperty(value = "任务类型")
	private String taskType;

	/** 出勤类型 */
	@ApiModelProperty(value = "出勤类型")
	private String attendType;

	/** 任务名称 */
	@ApiModelProperty(value = "任务名称")
	private String taskName;

	/** 任务地址 */
	@ApiModelProperty(value = "任务地址")
	private String address;
	/** 当前任务状态 */
	private String currentTaskStatus;// 1:正在执行,2:已完成,3:已结束,4:新任务,5:即将进行

	/** 任务内容 */
	@ApiModelProperty(value = "任务内容")
	private String taskDetail;

	/** 任务开始日期 */
	@ApiModelProperty(value = "任务开始日期")
	private Date startDate;

	/** 任务截止日期 */
	@ApiModelProperty(value = "任务截止日期")
	private Date endDate;
	/**
	 * 人员ID
	 */
	@ApiModelProperty(value = "人员ID")
	private Long perId;

	/** 任务结束状态(0:未结束，1：已结束) */
	@ApiModelProperty(value = "任务结束状态")
	private String taskOverStatus;

	/** 任务地址所在城市 */
	@ApiModelProperty(value = "任务地址所在城市")
	private Integer city;

	/** 定位城市名称 */
	@ApiModelProperty(value = "定位城市名称")
	private String cityName;

	/**
	 * 轮次执行时长
	 */
	@ApiModelProperty(value = "轮次执行时长")
	private String tipText;

	/**
	 * 发布时间(紧急）
	 */
	@ApiModelProperty(value = "发布时间(紧急）")
	private String releaseTime;

	/**
	 * 接受时间(紧急）
	 */
	@ApiModelProperty(value = "接受时间(紧急）")
	private String acceptTime;

	/**
	 * 完成时间
	 */
	@ApiModelProperty(value = "完成时间")
	private String finishTime;
	/**
	 * 当前选择年月日
	 */
	@ApiModelProperty(value = "当前选择日期")
	private String selectDate;

	/**
	 * 请求显示年
	 */
	@ApiModelProperty(value = "请求显示年")
	private Integer year;
	/**
	 * 请求显示月
	 */
	@ApiModelProperty(value = "请求显示月")
	private Integer month;
	/**
	 * 列表副标题一 ： 1、任务状态为执行中：除了紧急任务，放的是任务的开始时间-结束时间(时间格式：XXXX年XX月XX日)
	 * 2、任务状态为即将开始：除了紧急任务，放的是任务的下一轮次的开始时间-结束时间(时间格式：XXXX年XX月XX日 HH:mm)
	 * 3、任务状态为已完成：放的是任务的最后一轮次的签退时间(时间格式：XXXX年XX月XX日 HH:mm)
	 * 4、紧急任务即将开始、即将执行中：放的是任务的发布时间(时间格式：XXXX年XX月XX日 HH:mm)
	 * 5、任务状态为已结束：放的是任务的开始时间-结束时间(时间格式：XXXX年XX月XX日)
	 */
	@ApiModelProperty(value = "列表副标题一")
	private String subTitle1;

	/**
	 * 列表副标题二： 未结束的紧急任务放的接受时间(时间格式：XXXX年XX月XX日 HH:mm)其它都是放是任务地址
	 */
	@ApiModelProperty(value = "列表副标题二")
	private String subTitle2;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getPerId() {
		return perId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getTaskId() {
		return taskId;
	}

	@JsonFormat(pattern = "yyyy-MM-dd")
	public Date getStartDate() {
		return startDate;
	}

	@JsonFormat(pattern = "yyyy-MM-dd")
	public Date getEndDate() {
		return endDate;
	}

}
