package com.bcxin.oa.old.controller.task;


import com.bcxin.oa.old.dto.ParamDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.service.task.ComTaskPerShiftService;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.aspect.Log;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * <p>
 * 任务相关的人员排班
 * </p>
 *
 * @author 罗鹏
 * @date 2018/3/1
 */
@RestController
@RequestMapping("/task/com-task-per-shift")
public class ComTaskPerShiftController extends BaseController {

    @Resource
    private ComTaskPerShiftService comTaskPerShiftService;


    /**
     * 根据任务获得选择的班次/排班周期
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "人员排班", title = "根据任务获得选择的班次/排班周期")
    @PostMapping(value = "list-shift")
    @ApiOperation(value = "根据任务获得选择的班次/排班周期", httpMethod = "POST", notes = "根据任务获得选择的班次/排班周期", response = Result.class)
    public Result listShift(ParamDTO paramDTO) throws BusinessException {
        return comTaskPerShiftService.getShiftByTask(paramDTO);
    }


    /**
     * 根据任务获得人员排班详情(分页)
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "人员排班", title = "根据任务获得人员排班详情(分页)")
    @PostMapping(value = "page-per-shift")
    @ApiOperation(value = "根据任务获得人员排班详情(分页)", httpMethod = "POST", notes = "根据任务获得人员排班详情(分页)", response = Result.class)
    public Result pagePerShift(ParamDTO paramDTO) throws BusinessException {
        return comTaskPerShiftService.pagePerShift(paramDTO);
    }

    /**
     * 校验周期制排班的班次是否有冲突
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "校验周期制班次冲突", title = "校验周期制排班的班次是否有冲突")
    @PostMapping(value = "validate-schedule-cycle")
    @ApiOperation(value = "校验周期制班次冲突", httpMethod = "POST", notes = "校验周期制班次冲突", response = Result.class)
    public Result validateScheduleCycle(ParamDTO paramDTO) throws BusinessException {
        return comTaskPerShiftService.validateSchedulCycle(paramDTO);
    }


    /**
     * 校验一个人的单日的考勤，支持排班制和周期制
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "人员排班", title = "校验一个人的单日的考勤，支持排班制和周期制")
    @PostMapping(value = "validate-single-per-shift")
    @ApiOperation(value = "校验一个人的单日的考勤，支持排班制和周期制", httpMethod = "POST", notes = "校验一个人的单日的考勤，支持排班制和周期制", response = Result.class)
    public Result validateSinglePerShift(ParamDTO paramDTO) throws BusinessException {
        return comTaskPerShiftService.validateSinglePerShift(paramDTO);
    }


}
