package com.bcxin.oa.old.controller.task;

import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.dto.ComShiftDto;
import com.bcxin.oa.old.service.task.ComShiftService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;


@RestController
@RequestMapping("/task/com-shift")
@Api(tags = {"考勤管理-班次管理"}, value = "考勤管理-班次管理")
public class ComShiftController extends BaseController {

    @Resource
    private ComShiftService comShiftService;

    @GetMapping(value = "page")
    @ApiOperation(value = "班次管理分页查询", httpMethod = "GET", notes = "班次管理分页查询", response = ComShiftDto.class)
    public Result pageForShift(ComShiftDto comShiftDto) {
        return comShiftService.pageForShift(comShiftDto).setBack(getRequest());
    }

    @PostMapping(value = "insert")
    @ApiOperation(value = "新增班次管理", httpMethod = "POST", notes = "新增班次管理", response = ComShiftDto.class)
    public Result insert(ComShiftDto comShiftDto)throws BusinessException {
        return comShiftService.addShift(comShiftDto).setBack(getRequest());
    }

    @PostMapping(value = "update")
    @ApiOperation(value = "编辑班次管理", httpMethod = "POST", notes = "编辑班次管理", response = ComShiftDto.class)
    public Result update(ComShiftDto comShiftDto)throws BusinessException {
        return comShiftService.updateShift(comShiftDto).setBack(getRequest());
    }

    @PostMapping(value = "delete")
    @ApiOperation(value = "班次删除", httpMethod = "POST", notes = "班次删除", response = ComShiftDto.class)
    public Result deleteByPrimaryKey(ComShiftDto comShiftDto) throws BusinessException{
        return comShiftService.delete(comShiftDto).setBack(getRequest());
    }

    @GetMapping(value = "get")
    @ApiOperation(value = "班次详细信息查询", httpMethod = "GET", notes = "班次详细信息查询", response = ComShiftDto.class)
    public Result getByPrimaryKey(ComShiftDto comShiftDto) {
        return comShiftService.getByPrimaryKey(comShiftDto).setBack(getRequest());
    }
}
