package com.bcxin.oa.old.controller.salary;

import com.bcxin.oa.old.entity.salary.ComSalaryTemp;
import com.bcxin.oa.old.dto.salary.ComSalaryTempDTO;
import com.bcxin.oa.old.service.salary.web.ComSalaryTempService;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.aspect.Log;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * 企业薪酬模板的controller层
 * by llc 2018-12-28
 */
@RestController
@RequestMapping("/task/salary/temp")
@Api(tags = {""}, description = "企业薪酬模板")
public class ComSalaryTempController extends BaseController {

    @Resource
    private ComSalaryTempService comSalaryTempService;

    /**
     * 获取薪酬项目配置
     * @return
     * @author llc
     * @date 2018-12-28
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "获取薪酬项目配置", title = "获取薪酬项目配置", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @GetMapping(value = "get-config-salary-type")
    @ApiOperation(value = "获取薪酬项目配置", httpMethod = "GET", notes = "获取薪酬项目配置", response = Map.class)
    public Result getConfigSalaryType(ComSalaryTempDTO dto) {
        return comSalaryTempService.getConfigSalaryType().setBack(getRequest());
    }

    /**
     * 校验模板人员是否存在其他模板
     *
     * @param comSalaryTemp
     * @param perList
     * @return
     * @author llc
     * @date 2019-01-03
     */
    @PostMapping(value = "/check-salary-temp-per")
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "校验模板人员", title = "校验模板人员", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @ApiOperation(value = "校验模板人员", notes = "校验模板人员")
    public Result checkAttendPer(ComSalaryTemp comSalaryTemp ,String perList){
        return comSalaryTempService.checkSalaryTempPer(comSalaryTemp,perList).setBack(getRequest());
    }

    /**
     * 保存企业薪酬模板接口
     * @return
     * @author llc
     * @date 2018-12-28
     */
    @Log(operation = Log.OPERA_TYPE_SAVE, modle = "保存企业薪酬模板", title = "保存企业薪酬模板", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "save-com-salary-temp")
    @ApiOperation(value = "保存企业薪酬模板", httpMethod = "POST", notes = "保存企业薪酬模板", response = Map.class)
    public Result saveComSalaryTemp(ComSalaryTemp comSalaryTemp, HttpServletRequest request){
        return comSalaryTempService.saveComSalaryTemp(comSalaryTemp,getParams()).setBack(getRequest());
    }

    /**
     * 查询企业薪酬模板列表
     * @return
     * @author llc
     * @date 2018-12-29
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业薪酬模板列表分页查询", title = "企业薪酬模板列表分页查询", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @GetMapping(value = "page-com-salary-temp")
    @ApiOperation(value = "企业薪酬模板列表分页查询", httpMethod = "GET", notes = "企业薪酬模板列表分页查询", response = Map.class)
    public Result pageComSalaryTemp(ComSalaryTempDTO dto) {
        return comSalaryTempService.pageComSalaryTemp(dto).setBack(getRequest());
    }


    /**
     * 查询企业薪酬模板详情
     * @return
     * @author llc
     * @date 2018-12-29
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "查询企业薪酬模板详情", title = "查询企业薪酬模板详情", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @GetMapping(value = "get-com-salary-temp-info")
    @ApiOperation(value = "查询企业薪酬模板详情", httpMethod = "GET", notes = "查询企业薪酬模板详情", response = Map.class)
    public Result getComSalaryTempInfo(ComSalaryTemp comSalaryTemp) {
        return comSalaryTempService.getComSalaryTempInfo(comSalaryTemp).setBack(getRequest());
    }


    /**
     * 删除企业薪酬模板
     * @return
     * @author llc
     * @date 2018-12-29
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "删除企业薪酬模板", title = "删除企业薪酬模板", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "del-com-salary-temp")
    @ApiOperation(value = "删除企业薪酬模板", httpMethod = "POST", notes = "删除企业薪酬模板", response = Map.class)
    public Result delComSalaryTemp(ComSalaryTemp comSalaryTemp) {
        return comSalaryTempService.delComSalaryTemp(comSalaryTemp).setBack(getRequest());
    }


    /**
     * 复制企业薪酬模板
     * @return
     * @author llc
     * @date 2018-12-29
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "复制企业薪酬模板", title = "复制企业薪酬模板", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "copy-com-salary-temp")
    @ApiOperation(value = "复制企业薪酬模板", httpMethod = "POST", notes = "复制企业薪酬模板", response = Map.class)
    public Result copyComSalaryTemp(ComSalaryTemp comSalaryTemp) {
        return comSalaryTempService.copyComSalaryTemp(comSalaryTemp).setBack(getRequest());
    }

}
