import React, { Component } from 'react';
import PropTypes from 'prop-types';
import RreactDom from 'react-dom';
import {
  Spin
} from 'antd';
import './loading.less';
class LoadingComponent extends Component {
  render() {
    const { text } = this.props;
    return (
      <div className="loading_wrap">
        <Spin />
        {
          text && (
            <p style={{marginTop: 5, color: '#1890ff'}}>{text}</p>
          )
        }
      </div>
    );
  }
}
LoadingComponent.propTypes = {
  text: PropTypes.string,
};
export default {
  open(text = '') {
    // this.close();
    const div = document.createElement('div');
    div.setAttribute('class', 'bcx_loading');
    document.body.appendChild(div);
    RreactDom.render(React.createElement(LoadingComponent, {text}), div);
  },
  close: () => {
    const divs = document.getElementsByClassName('bcx_loading');
    Reflect.apply(Array.prototype.forEach, divs, [item => {
      RreactDom.unmountComponentAtNode(item);
      document.body.removeChild(item);
    }]);
  }
}