import store from 'store';
/* 
*  域名环境的区分
*/
const defaultName = '百保盾企业管理平台';
const beijing = '北京保安服务综合管理信息系统';
const guangxi = '广西智慧保安监管信息系统';
const shanxi = '陕西保安服务监管信息系统';
const ningxia = '宁夏保安服务监管信息系统';
const yanan = '延安保安服务监管信息系统';

// 根据域名获取系统名字
function getNameFromDomain () {
  let name = defaultName;
  const prefix = window.location.hostname.split('.')[0];  //localhost, 114
  switch (true) {
    case prefix == 'bjba':
      name = beijing;
      break;
    case prefix == 'gxba':
      name = guangxi;
      break;
    case prefix == 'snba':
      name = shanxi;
      break;
    case prefix == 'nxba':
      name = ningxia;
      break;
    case prefix == 'yaba':
      name = yanan;
    // break;
    //测试环境和开发环境
    // case prefix == 'localhost' || prefix == '114':
  }
  return name;
}
const domainConf = {
  name: defaultName,
  https: 'https://attendsweb.test.baibaodun.cn',//定义跳转的https路径(测试环境)
  // 通过省份id判断区域
  getName(regProvince,regCity='') {
    // let name = this.name;
    let name = defaultName;
    // 登录的情况
    if(store.get('saas') && store.get('saas')['access_token']) {
      switch (true) {
        case /^11/.test(regProvince):
          name = beijing;
          break;
        case /^45/.test(regProvince):
          name = guangxi;
          break;
        case /^61/.test(regProvince):
          //陕西省的精确到市级的名称
          if(/^6106/.test(regCity)){
            name = yanan;
          }else{
            name = shanxi;
          }
          break;
        case /^64/.test(regProvince):
          name = ningxia;
      }
    }else { //未登录的情况下使用域名判断
      name = getNameFromDomain();
    }
    return name;
  }
};
const prefix = window.location.hostname.split('.')[0];  //localhost, test
domainConf.prefix = prefix;
// 正式环境
if (prefix != 'localhost' && prefix != 'attendsweb') {
  domainConf.https = 'https://paspweb.bcx.bcxin.com.cn:14433';
}
domainConf.name = getNameFromDomain();
export const domainConfig = domainConf;

/* 
* im环境
* v5的跟saas的测试区分
*/
export const imKey = {
  SDKAppID: /paspweb\.bcx\.bcxin\.com\.cn/.test(window.location.hostname) ? 1400526063 : 
  1400522511
};

/**
 * 根据不同环境配置接口地址
 */
// const apiPrefix = '/v5_api';
export function getHostByPath(param='') {
  let host
  const NODE_EVN = process.env.NODE_ENV;//'development'本地开发环境
  // const isTestEnv= window.location.hostname == 'attendsweb.test.baibaodun.cn'//测试环境
  let isTestEnv= window.location.hostname == 'attendsweb.test.baibaodun.cn'//测试环境

  //此处都是配置的测试环境的接口地址，后续上生产，需要具体在配置
  switch(param){
    case '':
      if(NODE_EVN=='development'||isTestEnv){
        //测试环境
        // host = 'http://192.168.0.22:7080'
        host = 'https://attends.test.baibaodun.cn'
        // host = 'https://pasp.ba.baibaodun.com.cn'
        // host ='http://192.168.30.182:7080'
        // if(/\/command\//.test(location.href)&&/https:/.test(location.href)){
        //   host = 'https://attends.test.baibaodun.cn'//防控指挥的接口需要https链接，请求接口
        // }
      }else{
        //正式环境
        host = 'https://attends.test.baibaodun.cn'
        // host = 'https://pasp.ba.baibaodun.com.cn'
      }
      return host
    case 'v5base':
      if(NODE_EVN=='development'||isTestEnv){
        //v5的基础测试环境
        if(/\/command\//.test(location.href)&&/https:/.test(location.href)){
          host ='https://v5qy.te.baibaodun.com.cn'//防控指挥的接口需要https链接，请求接口
          // host ='https://v5qy.baibaodun.cn'
        }else{
          host = 'https://v5qy.te.baibaodun.com.cn'
          // host ='https://v5qy.baibaodun.cn'
        }
      }else{
        //正式环境
        if(/\/command\//.test(location.href)&&/https:/.test(location.href)){
          host ='https://v5qy.baibaodun.cn'
        }else{
          host='https://v5qy.baibaodun.cn'
        }
      }
    return host;
    case 'v5common':
      if(NODE_EVN=='development'||isTestEnv){
        //v5的公共服务的测试环境
        if(/\/command\//.test(location.href)&&/https:/.test(location.href)){
          host = 'https://identify.test.bcxin.com.cn'
        }else{
          host = 'https://identify.test.bcxin.com.cn'
        }
      }else{
        //正式环境
        if(/\/command\//.test(location.href)&&/https:/.test(location.href)){
          host = 'https://identify.bcxin.com.cn:14433'
        }else{
          // host= 'https://identify.bcxin.com.cn'
          host = 'https://identify.bcxin.com.cn:14433'
        }
      }
      return host;
    case 'saas':
      host = 'https://saasweb.test.baibaodun.cn:9029/saas_api'
      return host;
  }
}

// 翔云OCR配置
export const xiangyunKey = {
    key: "Es1TRT94hJsvSttv9GLhy4",
    secret: "19d6be2e3e164f98a1b7d1321a73189c"
}