/**
 * 云会议室
 */
import React, { Component } from "react";
import { connect } from "dva";
import { Form, message, Modal, Button, Tabs } from "antd";
import MyMeeting from "./MyMeeting/index";
import { getHuaweiAccesstoken, getComHuaweiMeet } from "../../services/api";
import "./meeting.less";
const { confirm } = Modal;
const { TabPane } = Tabs;
global.canInitLogin = function () {
  window.canInitLoginState = true;
};
@connect((state) => ({
  client: state.client.client,
  loginStatus: state.client.loginStatus,
  meetingToken: state.client.meetingToken,
  meetingAcount: state.client.meetingAcount,
  meetingPass: state.client.meetingPass,
  currentConferTopic: state.client.currentConferTopic,
  isKickOut: state.client.isKickOut,
  userName: state.user.currentUser.name,
}))
@Form.create()
export default class Meeting extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      client: null,
      // options: options,
      updateMeetListState: false,
      meetingToken: props.meetingToken,
      meetingAcount: props.meetingAcount,
      meetingPass: props.meetingPass,
      noHasResoult: true, //企业有购买资源，账户没有开通权限（默认是有）
    };
  }
  componentDidMount() {
    //浏览器打开多个页面（关闭之前的页面，只能留一个页面）
    // window.addEventListener("storage", function () {
    //   window.location.href = "about:blank";
    //   window.close();
    // });
    // if (!this.props.client) {
    //   // this.initial();
    //   const client = initial.call(this);
    //   this.setState({
    //     client,
    //   });
    // } else {
    //   //已经存在
    //   this.setState({
    //     client: this.props.client,
    //   });
    // }
    //没有登录的时候，先请求有没有购买，第二登录鉴权
    // if (!this.props.loginStatus) {
    //   //1、有请求过账号，只是还没登录
    //   //2、没请求过账号信息
    //   if (this.state.meetingAcount) {
    //     const interval = setInterval(() => {
    //       if (window.canInitLoginState && this.props.client) {
    //         //要等插件加载成功，并且初始化client同时完成
    //         this.handleSubmit();
    //         clearInterval(interval);
    //       }
    //     }, 1000);
    //   } else {
        this._getComHuaweiMeet();
    //   }
    // }
  }
  componentWillReceiveProps(nextProps) {
    this.setState({
      meetingToken: nextProps.meetingToken,
      meetingAcount: nextProps.meetingAcount,
      meetingPass: nextProps.meetingPass,
    });
  }
  _getComHuaweiMeet() {
    getComHuaweiMeet({}).then((res) => {
      if (res.data) {
        // this.getMeetingToken();
      } else {
        const _this = this;
        confirm({
          title: "您的企业尚未开通云会议服务",
          content: "企业开通云会议服务后，方可使用云会议的相关功能。",
          okText: "去开通",
          cancelText: "取消",
          onOk() {
            _this.props.history.push("/meeting/buy-setMeal");
          },
          onCancel() {
            message.warning("您还没有权限使用");
          },
        });
      }
    });
  }

  // //获取华为云会议的token
  // getMeetingToken() {
  //   const that = this;
  //   getHuaweiAccesstoken({})
  //     .then((res) => {
  //       if (res.retType === "0") {
  //         this.props.dispatch({
  //           type: `client/setMeetingToken`,
  //           payload: {
  //             meetingAcc: res.data,
  //           },
  //         });
  //         const interval = setInterval(() => {
  //           if (window.canInitLoginState && this.props.client) {
  //             //要等插件加载成功，并且初始化client同时完成
  //             that.handleSubmit();
  //             clearInterval(interval);
  //           }
  //         }, 1000);
  //       } else {
  //       }
  //     })
  //     .catch((err) => {
  //       if (err.retType !== "0") {
  //         this.setState({
  //           noHasResoult: false,
  //         });
  //       }
  //     });
  // }
  //获取与会者列表
  // getAttendeeList() {
  //   const _this = this;
  //   this.props.client.getAttendeeList(function (ret) {
  //     if (ret.result) {
  //       _this.props.dispatch({
  //         type: `client/setAttenList`,
  //         payload: {
  //           attenList: ret.info,
  //         },
  //       });
  //     }
  //     if (window.setHweiMeeingNickname) {
  //       _this.props.client.renameSelf(window.setHweiMeeingNickname);
  //     }
  //     window.setHweiMeeingNickname = null;
  //   });
  // }
  //登录
  // handleSubmit() {
  //   /**
  //    * 检查守护进程的版本号
  //    * 1、目前最新版本V19.1.18，这个版本之前的都没有getVersion方法
  //    * 2、不强制更新版本
  //    */
  //   let isNewVersion = false;
  //   this.state.client.getVersion(function (data) {
  //     //TODO
  //     isNewVersion = true;
  //   });
  //   this.login()
  //   setTimeout(() => {
  //     if (isNewVersion) {
        
  //     } else {
  //       Modal.confirm({
  //         title: "请先更新视频插件并启动成功，然后重启页面。是否立即下载?",
  //         okText: "更新下载",
  //         cancelText:'取消',
  //         maskClosable: false,
  //         onOk() {
  //           let a = document.createElement("a");
  //           a.href = uploadCloudLinkMeetingDaemonUrl ;
  //           a.click();
  //         },
  //         onCancel() {
  //           message.warning(
  //             "您还未正确更新插件，请按照提示完成插件下载与安装，以免影响到部分功能"
  //           );
  //         },
  //       });
  //     }
  //     // clearTimeout(interval);
  //   }, 300);
  // }
  // login(){
  //   var account = this.state.meetingAcount;
  //     var passwd = this.state.meetingPass;
  //     var serverAddress = "bmeeting.huaweicloud.com";
  //     var serverPort = "443";
  //     const _this = this;
  //     this.state.client.login(
  //       0,
  //       { account: account, passwd: passwd },
  //       { serverAddress: serverAddress, serverPort: parseInt(serverPort) },
  //       function callback(evt) {
  //         if (!evt.result) {
  //           message.error("登录失败，请先检查是否在其他终端登录了");
  //         } else {
  //           _this.props.dispatch({
  //             type: `client/setLogin`,
  //             payload: {
  //               loginStatus: true,
  //             },
  //           });
  //           _this.props.dispatch({
  //             type: `client/setISKickOut`,
  //             payload: {
  //               isKickOut: false,
  //             },
  //           });
  //           _this.state.client.setDisplayName(_this.props.userName);
  //         }
  //       }
  //     );
  // }
  render() {
    return (
      <div className="meeting">
        <Tabs defaultActiveKey="1">
          <TabPane tab="会议列表" key="1">
            {/* {this.props.isKickOut ? (
              <div>
                <span>由于您的账号在其他地方登录，需要点击</span>
                <Button
                  type="primary"
                  onClick={() => {
                    this.handleSubmit();
                  }}
                >
                  初始化
                </Button>
              </div>
            ) : (
              <div>
                {this.state.noHasResoult && <MyMeeting />}

                {!this.state.noHasResoult && <AnonymousJoin />}
              </div>
            )} */}
            <MyMeeting />
          </TabPane>
        </Tabs>
      </div>
    );
  }
}
