/**
 * 会议详情
 */
import React, { Component } from "react";
import { connect } from "dva";
import { Form, Drawer, Input, Button, message } from "antd";
import { getHuaweiMeetDetail } from '../../../services/api';
import { addUTC } from '../../../utils/utils';
@connect(state => ({
  client: state.client.client
}))
@Form.create()
export default class Datail extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      visible: this.props.visible,
      clickConferenceID: this.props.clickConferenceID,
      detailData: {} //详情信息数据
    };
  }
  componentDidMount() { }

  componentWillReceiveProps(nextProps) {
    this.setState({
      visible: nextProps.visible,
      clickConferenceID: nextProps.clickConferenceID
    });

    if (this.state.visible !== nextProps.visible && nextProps.visible) {
      this.getDetail(nextProps.clickConferenceID);
    }
  }
  //获取详情信息
  getDetail(conferenceId) {
    getHuaweiMeetDetail({ conferenceId }).then(res => {
      console.log(res)
      if (res.retType == '0') {
        this.setState({
          detailData: res.data.conferenceData
        });
      }
    })
    // this.props.client.getMyConfInfo(conferenceID, function(ret) {
    //   if (ret.result) {
    //     _this.setState({
    //       detailData: ret.info
    //     });
    //   }
    // });
  }
  //加入会议
  // joinMeeting() {
  //   this.props.onChange(false)
  //   var defaultPsw = "******";
  //   var confPsw = this.state.detailData.chairmanPasswd;
  //   if (confPsw == defaultPsw || confPsw == "") {
  //     confPsw = this.state.detailData.generalPasswd;
  //   }
  //   let joinConfParam = {
  //     conferenceId: this.state.detailData.conferenceID,
  //     accessNumber: this.state.detailData.accessNumber,
  //     confPasswd: confPsw
  //   };
  //   const _this = this;
  //   this.props.client.joinConference(joinConfParam, function(ret) {
  //     if (ret.result) {
  //       _this.props.dispatch({
  //         type: `client/setCurrentConferID`,
  //         payload: {
  //           currentConferID: _this.state.detailData.conferenceID,
  //           currentConferTopic: _this.state.detailData.topic
  //         }
  //       });
  //     } else {
  //       message.warning("会议加入失败")
  //     }
  //   });
  // }
  searchPassward(data, param) {
    let text = '-'
    if (data.length > 0) {
      data.map(item => {
        if (item['conferenceRole'] == param) {
          text = item['password'] ? item['password'] : '-'
        }
      })
    }
    return text
  }
  render() {
    const { subject, startTime, endTime, conferenceID, passwordEntry, mediaTypes,conferenceState } = this.state.detailData
    return (
      <div>
        <Drawer
          title="会议详情"
          placement="right"
          closable={false}
          onClose={() => {
            this.props.onChange(false)
          }}
          visible={this.state.visible}
        >
          <p>会议主题：{subject}</p>
          <p>会议开始时间：{addUTC(startTime, 'add')}</p>
          <p>会议结束时间：{addUTC(endTime, 'add')}</p>
          <p>会议ID：{conferenceID}</p>
          <p>主席密码：{passwordEntry&&this.searchPassward(passwordEntry, 'chair')}</p>
          <p>来宾密码：{passwordEntry&&this.searchPassward(passwordEntry, 'general')}</p>
          {/* <p>主席密码：{passwordEntry&&passwordEntry[0].password}</p>
          <p>来宾密码：{passwordEntry&&passwordEntry[1].password}</p> */}
          <p>
            会议类型：
            {/* {this.state.detailData.mediaType === 0
              ? "音频"
              : this.state.detailData.mediaType === 1
                ? "视频"
                : this.state.detailData.mediaType === 2
                  ? "音频"
                  : this.state.detailData.mediaType === 3
                    ? "视频"
                    : "其他类型"} */}
            {mediaTypes ? mediaTypes.indexOf('Video') > -1 ? mediaTypes.indexOf('HDVideo') > -1 ? '高清视频' : '标清视频' : '语音' : '其他类型'}
          </p>
          <p>
            会议状态：
            {conferenceState =='Schedule'
              ? "预定状态"
              : conferenceState =='Creating'
                ? "正在创建"
                : conferenceState =='Created'
                  ? "会议已经开始"
                  : conferenceState =='Destroyed'
                    ? "会议已经结束"
                    : ""}
          </p>
          {/* <Button
            type="primary"
            onClick={() => {
              this.joinMeeting();
            }}
          >
            加入会议
          </Button> */}
        </Drawer>
      </div>
    );
  }
}
