/**
 * 购买云会议套餐
 */
import React, { Component } from "react";
import { connect } from "dva";
import {
  message,
  Input,
  Form,
  Card,
  Tabs,
  Checkbox,
  Breadcrumb,
  Button,
  Row,
  Col,
  Table,
  Modal,
  Alert
} from "antd";
import "../meeting.less";
import { withRouter } from "dva/router";
import { formatCurrency } from "../../../utils/utils";
import {
  checkOrder,
  getPayPhone,
  sendPayVerifycode,
  saveOrder
} from "../../../services/api";
const { TabPane } = Tabs;
const { Meta } = Card;
const setMeal = [
  {
    name: "50方云会议室套餐",
    content: [
      "满足培训机构线上考试监考使用",
      "会议室可容纳50方开会",
      "100G录屏空间"
    ],
    detail: [
      {
        duration: 1,
        unit: "元/个/年",
        amount: 7500,
        num: 1,
        eachAmount: "7500",
        productBuyModeId: "11020302",
        productName: "50方云会议室"
      },
      {
        duration: 1,
        unit: "元/个/年",
        amount: 3910,
        num: 1,
        eachAmount: "3910",
        productBuyModeId: "11090202",
        productName: "100G录屏空间"
      }
    ],
    allAmont: 11410,
    price: 11410.0, //单个原价
    concessionalPrice: 9128.0, //套餐价(优惠价)
    background: require("../../../assets/images/meeting1.png"),
    afterMonth: "12"
  },
  {
    name: "100方云会议室套餐",
    content: [
      "满足培训机构线上考试监考使用",
      "会议室可容纳100方开会",
      "100G录屏空间"
    ],
    detail: [
      {
        duration: 1,
        unit: "元/个/年",
        amount: 15000,
        num: 1,
        eachAmount: "15000",
        productBuyModeId: "11020402",
        productName: "100方云会议室"
      },
      {
        duration: 1,
        unit: "元/个/年",
        amount: 3910,
        num: 1,
        eachAmount: "3910",
        productBuyModeId: "11090202",
        productName: "100G录屏空间"
      }
    ],
    allAmont: 18910,
    price: 18910.0, //单个原价
    concessionalPrice: 15128.0, //套餐价
    background: require("../../../assets/images/meeting2.png"),
    afterMonth: "12"
  },
  {
    name: "套餐A（基础套餐）",
    content: ["2个个人账号：可赋予20人开会权限，拥有会议权限用户均可以创建会议和加入会议，但同一时间开会人数不能大于2方"],
    detail: [
      {
        duration: 1,
        unit: "元/个/年",
        amount: 3000,
        num: 2,
        eachAmount: "1500",
        productBuyModeId: "11010102",
        productName: "会议账户数"
      }
    ],
    allAmont: 3000,
    price: 3000.0, //单个原价
    concessionalPrice: 2400.0, //套餐价
    background: require("../../../assets/images/meeting3.png"),
    afterMonth: "12"
  },
  {
    name: "套餐B（基础套餐）",
    content: [
      "小型会议室：企业云会议可同时容纳10方开会",
      "注：可开通10个会议账户"
    ],
    detail: [
      {
        duration: 1,
        unit: "元/个/年",
        amount: 2500,
        num: 1,
        eachAmount: "2500",
        productBuyModeId: "11020102",
        productName: "10方云会议室"
      }
    ],
    allAmont: 2500,
    price: 2500.0, //单个原价
    concessionalPrice: 2000.0, //套餐价
    background: require("../../../assets/images/meeting4.png"),
    afterMonth: "12"
  },
  {
    name: "套餐C（1人-99人企业）",
    content: [
      "5个个人账号：可赋予50人开会权限，拥有会议权限用户均可以创建会议和加入会议，但同一时间开会人数不能大于5方",
      "小型云会议室：企业云会议室可同时容纳10方开会"
    ],
    detail: [
      {
        duration: 1,
        unit: "元/个/年",
        amount: 7500,
        num: 5,
        eachAmount: "1500",
        productBuyModeId: "11010102",
        productName: "会议账户数"
      },
      {
        duration: 1,
        unit: "元/个/年",
        amount: 2500,
        num: 1,
        eachAmount: "2500",
        productBuyModeId: "11020102",
        productName: "10方云会议室"
      }
    ],
    allAmont: 10000,
    price: 10000.0, //单个原价
    concessionalPrice: 8000.0, //套餐价
    background: require("../../../assets/images/meeting5.png"),
    afterMonth: "12"
  },
  {
    name: "套餐D（100人-299人企业）",
    content: [
      "10个个人账号：可赋予100人开会权限，拥有会议权限用户均可以创建会议和加入会议，但同一时间开会人数不能大于10方",
      "小型云会议室：企业云会议室可同时容纳10方开会",
      "中型云会议室：企业云会议室可同时容纳50方开会"
    ],
    detail: [
      {
        duration: 1,
        unit: "元/个/年",
        amount: 15000,
        num: 10,
        eachAmount: "1500",
        productBuyModeId: "11010102",
        productName: "会议账户数"
      },
      {
        duration: 1,
        unit: "元/个/年",
        amount: 2500,
        num: 1,
        eachAmount: "2500",
        productBuyModeId: "11020102",
        productName: "10方云会议室"
      },
      {
        duration: 1,
        unit: "元/个/年",
        amount: 7500,
        num: 1,
        eachAmount: "7500",
        productBuyModeId: "11020202",
        productName: "50方云会议室"
      }
    ],
    allAmont: 25000,
    price: 25000.0, //单个原价
    concessionalPrice: 20000.0, //套餐价
    background: require("../../../assets/images/meeting6.png"),
    afterMonth: "12"
  },
  {
    name: "套餐E（300人-999人企业）",
    content: [
      "20个个人账号：可赋予200人开会权限，拥有会议权限用户均可以创建会议和加入会议，但同一时间开会人数不能大于20方",
      "小型云会议室：企业云会议室可同时容纳10方开会",
      "中型云会议室：企业云会议室可同时容纳50方开会"
    ],
    detail: [
      {
        duration: 1,
        unit: "元/个/年",
        amount: 30000,
        num: 20,
        eachAmount: "1500",
        productBuyModeId: "11010102",
        productName: "会议账户数"
      },
      {
        duration: 1,
        unit: "元/个/年",
        amount: 2500,
        num: 1,
        eachAmount: "2500",
        productBuyModeId: "11020102",
        productName: "10方云会议室"
      },
      {
        duration: 1,
        unit: "元/个/年",
        amount: 7500,
        num: 1,
        eachAmount: "7500",
        productBuyModeId: "11020302",
        productName: "50方云会议室"
      }
    ],
    allAmont: 40000,
    price: 40000.0, //单个原价
    concessionalPrice: 32000.0, //套餐价
    background: require("../../../assets/images/meeting7.png"),
    afterMonth: "12"
  },
  {
    name: "套餐F（＞1000人企业）",
    content: [
      "30个个人账号：可赋予300人开会权限，拥有会议权限用户均可以创建会议和加入会议，但同一时间开会人数不能大于30方",
      "小型云会议室：企业云会议室可同时容纳10方开会",
      "中型云会议室：企业云会议室可同时容纳50方开会",
      "大型云会议室：企业云会议室可同时容纳100方开会"
    ],
    detail: [
      {
        duration: 1,
        unit: "元/个/年",
        amount: 45000,
        num: 30,
        eachAmount: "1500",
        productBuyModeId: "11010102",
        productName: "会议账户数"
      },
      {
        duration: 1,
        unit: "元/个/年",
        amount: 2500,
        num: 1,
        eachAmount: "2500",
        productBuyModeId: "11020102",
        productName: "10方云会议室"
      },
      {
        duration: 1,
        unit: "元/个/年",
        amount: 7500,
        num: 1,
        eachAmount: "7500",
        productBuyModeId: "11020302",
        productName: "50方云会议室"
      },
      {
        duration: 1,
        unit: "元/个/年",
        amount: 15000,
        num: 1,
        eachAmount: "15000",
        productBuyModeId: "11020402",
        productName: "100方云会议室"
      }
    ],
    allAmont: 70000,
    price: 70000.0, //单个原价
    concessionalPrice: 56000.0, //套餐价
    background: require("../../../assets/images/meeting8.png"),
    afterMonth: "12"
  }
];
const formItemLayout = {
  labelCol: {
    xs: { span: 12 },
    sm: { span: 5 }
  },
  wrapperCol: {
    xs: { span: 12 },
    sm: { span: 13 }
  }
};
@connect(state => ({}))
@withRouter
@Form.create()
export default class BuySetMeal extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      mobilePhone: "",
      paymentStatus: false,
      confirmStatus: false, //确认订单的状态
      verificationName: "获取验证码", //验证码按钮名称
      selectValue: null, //选中的列表值
      checkbox: false //是否点击了同意按钮
    };
  }
  //支付校验
  _checkOrder(productValue) {
    console.log(productValue)
    checkOrder({
      actualPayAmount: productValue.allAmont
    }).then(res => {
      if (res.retType === "0") {
        this.setState({
          confirmStatus: !this.state.confirmStatus
        });
        this._getPayPhone();
      }
    });
  }
  //获取企业钱包账户资料
  _getPayPhone() {
    getPayPhone({}).then(res => {
      if (res.retType === "0") {
        this.setState({
          mobilePhone: res.data,
          paymentStatus: !this.state.paymentStatus
        });
      }
    });
  }
  //选中立即购买按钮
  changeSelect(item) {
    this.setState({
      confirmStatus: !this.state.confirmStatus,
      selectValue: item
    });
  }
  //确认提交订单
  _saveOrder() {
    const { selectValue } = this.state;
    this.props.form.validateFields((err, values) => {
      if (!err) {
        const data = {
          activeCode: values.activeCode,
          orderDetailListStr: JSON.stringify(selectValue.detail),
          amount: selectValue.allAmont,
          actualPayAmount: selectValue.allAmont,
          productCategoryType: 11
        };
        saveOrder({
          ...data
        }).then(res => {
          if (res.retType === "0") {
            this.setState({
              paymentStatus: !this.state.paymentStatus
            });
            const _this = this;
            Modal.success({
              title: "支付成功！",
              content: (
                <p>
                  云会议资源购买订单支付后，系统将进行资源分配，预计1~2个工作日完成。
                </p>
              ),
              okText: "查看订单",
              onOk() {
                _this.props.changeKeyTab('3')
              }
            });
          }
        });
      }
    });
  }
  render() {
    const { getFieldDecorator } = this.props.form;
    const {
      mobilePhone,
      paymentStatus,
      confirmStatus,
      selectValue,
      checkbox
    } = this.state;
    const columns = [
      {
        title: "产品名称",
        dataIndex: "name",
        key: "name",
        width: 180
      },
      {
        title: "产品详情",
        dataIndex: "detail",
        key: "detail",
        width: 310,
        render: (text, record) => (
          <div>
            {text.map((item,index) => {
              return (
                <span style={{ display: "inline-block" }} key={index}>
                  {item.productTypeName}（{item.productName}）{item.eachAmount}
                  {item.unit} 数量{item.num}个
                </span>
              );
            })}
          </div>
        )
      },
      {
        title: "原价（元）",
        dataIndex: "allAmont",
        key: "allAmont",
        render: (text, record) => (
          <span>
            {formatCurrency(text)}
          </span>
        )
      },
      // {
      //   title: "优惠价(元）",
      //   dataIndex: "concessionalPrice",
      //   key: "concessionalPrice",
      //   render: (text, render) => <span>{formatCurrency(text)}</span>
      // }
    ];
    return (
      <div className="buy-setMeal">
        <div
          style={{
            color: "#F59A23"
          }}
        >
          一方账号可使用一种类型设备包括：电脑/手机
        </div>
        <div className="buy-content">
          <Row>
            {setMeal.map((item, index) => {
              return (
                <Col
                  xs={{ span: 18, offset: 1 }}
                  xl={{ span: 11, offset: 1 }}
                  xxl={{ span: 7, offset: 1 }}
                  className="gutter-row"
                  style={{ marginBottom: "10px" }}
                  key={index}
                >
                  <div className="gutter-box">
                    <div className="meeting-card">
                      <Card
                        cover={
                          <img
                            className="background"
                            alt="example"
                            src={item.background}
                          />
                        }
                      >
                        <div className="set-label">
                          <p className="table">{item.name}</p>
                          <div className="set-content">
                            {item.content.map((item,index) => {
                              return <p key={index} style={{marginBottom:'0.3rem'}}>{item}</p>;
                            })}
                          </div>
                          <div className="price" style={{display:'inline-block'}}>
                            ¥ {formatCurrency(item.price)}
                          </div>
                          <span className="set-content">
                            价格/年
                          </span>
                          {/* <p className="set-content">
                            优惠价格/年（2020年{item.afterMonth}
                            月前购买享受优惠价格）
                          </p> */}
                          {/* <p style={{ textDecoration: "line-through" }}>
                            ¥{formatCurrency(item.price)} 单套餐原价/年
                          </p> */}
                          <div
                            className="set-button"
                            onClick={() => {
                              this.changeSelect(item);
                            }}
                          >
                            立即购买
                          </div>
                        </div>
                      </Card>
                    </div>
                  </div>
                </Col>
              );
            })}
          </Row>
        </div>
        <Modal
          className="set-modal"
          title="确认套餐"
          visible={confirmStatus}
          okText="确定支付"
          cancelText="返回套餐列表"
          onCancel={() => {
            this.setState({
              confirmStatus: !this.state.confirmStatus
            });
          }}
          onOk={() => {
            if (checkbox) {
              this._checkOrder(selectValue);
            } else {
              message.warning("请先勾选支付协议");
            }
          }}
        >
          <div>
            <Alert
              message={
                <div style={{ color: "#333" }}>
                  <div>
                    1、购买云会议资源，仅支持企业钱包支付，请提前充值购买资金到企业钱包中（若未开通，请访问【组织权益】-【企业钱包】进行开通）；
                  </div>
                  <div>
                    2、下单支付完成后，无法退款，请等待系统配置资源，预计1~2个工作日后配置完成；
                  </div>
                  <div>
                    3、若您需要增加购买其他内容，可重新下单，勾选需要的产品进行购买即可。
                  </div>
                </div>
              }
              type="warning"
              showIcon
              style={{ marginBottom: "15px" }}
            />
            <Table
              columns={columns}
              dataSource={[selectValue]}
              pagination={false}
              rowKey={record => record.prodsuctBuyModeId}
              style={{ width: "100%", marginBottom: "20px" }}
            />
            <div style={{ margin: "10px 0" }}>
              <Checkbox
                onChange={e => {
                  this.setState({
                    checkbox: e.target.checked
                  });
                }}
              >
                支付前请阅读并同意
              </Checkbox>
              <a
                href="https://wiki.baibaodun.cn/document/indexout?document_id=1475"
                target="_blank"
                rel="noopener noreferrer"
              >
                《百保盾云会议服务使用说明》
              </a>
            </div>
          </div>
        </Modal>
        <Modal
          title="企业钱包支付"
          visible={paymentStatus}
          onOk={() => {
            this._saveOrder();
          }}
          onCancel={() => {
            this.setState({
              paymentStatus: !this.state.paymentStatus
            });
            this.props.form.resetFields();
          }}
        >
          <Alert
            message={
              <div style={{ color: "#333" }}>
                <span>
                  购买云会议资源，当前仅支持企业钱包支付，请提前充值购买资金到企业钱包中；
                  下单支付完成后，需等待系统配置资源，预计1~2个工作日后生效。
                </span>
              </div>
            }
            type="warning"
            showIcon
            style={{ marginBottom: "15px" }}
          />
          <div>
            <Form>
              <Form.Item {...formItemLayout} label="绑定手机号">
                {getFieldDecorator("mobilePhone", {
                  // initialValue: this.state.mobilePhone,
                  // rules: [{ required: true, message: "请输入绑定手机号" }]
                })(
                  <div>
                    <Input
                      placeholder={mobilePhone}
                      style={{ width: "140px", marginRight: "10px" }}
                      disabled
                    />
                    <Button
                      type="primary"
                      disabled={this.state.time > 0}
                      onClick={() => {
                        let { time, timer } = this.state;
                        if (time > 0) return;
                        if (timer) clearInterval(timer);
                        if (!mobilePhone || !/^\d{11}$/.test(mobilePhone)) {
                          return message.error({
                            message: "系统没有获取到手机号"
                          });
                        }
                        //发送验证码
                        sendPayVerifycode({}).then(res => {
                          time = 59;
                          this.setState({
                            verificationName: `重试(${time}s)`,
                            time
                          });
                          timer = setInterval(() => {
                            time -= 1;
                            if (time > 0) {
                              this.setState({
                                time,
                                verificationName: `重试(${time}s)`,
                                timer
                              });
                            } else {
                              clearInterval(timer);
                              this.setState(
                                {
                                  verificationName: "获取验证码",
                                  timer: null
                                },
                                () => {
                                  this.setState({
                                    time: 0
                                  });
                                }
                              );
                            }
                          }, 1000);
                        });
                      }}
                    >
                      {this.state.verificationName}
                    </Button>
                  </div>
                )}
              </Form.Item>
              <Form.Item {...formItemLayout} label="短信验证码">
                {getFieldDecorator("activeCode", {
                  // initialValue: "Video",
                  rules: [{ required: true, message: "请输入短信验证码" }]
                })(
                  <Input
                    placeholder="请输入验证码"
                    style={{ width: "80%" }}
                  />
                )}
              </Form.Item>
            </Form>
          </div>
        </Modal>
      </div>
    );
  }
}
