import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const InsuranceOfficer = app => {
  return {
    name: '负责人',
    icon: 'user',
    path: 'insuranceOfficer',
    component: dynamicWrapper(app, ['insurance'], () =>
      import('../routes/Insurance/InsuranceOfficer')
    )
  };
};