"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var enum_1 = require("../enum");
var fs_1 = require("fs");
var debug = require("debug");
var path_1 = require("path");
// import { generateStatsFile } from '../utils';
var log = debug('bigbrother-webpack-plugin:adapter');
var SatoriAdapter = /** @class */ (function () {
    function SatoriAdapter() {
        var SatoriClient = require('@alipay/satori-client');
        this.satoriClient = new SatoriClient('bigfish-build', {
            timeout: 10000,
        });
    }
    SatoriAdapter.prototype.postBuild = function (args, _) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                log('Post build args:');
                log(JSON.stringify(args, null, 2));
                if (this.ifSkipBuildReport(args)) {
                    return [2 /*return*/];
                }
                try {
                    // const stateFilePath = this.getStateFilePath();
                    // await generateStatsFile(stateFilePath, stats);
                    this.saveFile(args);
                }
                catch (_) {
                    log(_);
                }
                return [2 /*return*/];
            });
        });
    };
    SatoriAdapter.prototype.postDev = function (args, _) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                log('Post dev args:');
                log(JSON.stringify(args, null, 2));
                if (this.ifDevReport(args)) {
                    return [2 /*return*/];
                }
                return [2 /*return*/];
            });
        });
    };
    SatoriAdapter.prototype.uploadShameimaru = function (shameimaru) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var url, _1;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, this.satoriClient.uploadShameimaru(JSON.stringify(shameimaru))];
                    case 1:
                        url = _a.sent();
                        return [3 /*break*/, 3];
                    case 2:
                        _1 = _a.sent();
                        log(_1);
                        return [3 /*break*/, 3];
                    case 3: return [2 /*return*/, url];
                }
            });
        });
    };
    SatoriAdapter.prototype.uploadStatusFile = function (statsPath) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var url, _2;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, this.satoriClient.uploadFrontendStats(fs_1.readFileSync(statsPath))];
                    case 1:
                        url = _a.sent();
                        return [3 /*break*/, 3];
                    case 2:
                        _2 = _a.sent();
                        log(_2);
                        return [3 /*break*/, 3];
                    case 3: return [2 /*return*/, url];
                }
            });
        });
    };
    SatoriAdapter.prototype.ifSkipBuildReport = function (data) {
        // 环境变量跳过上报: 设置环境变量 NO_BIGBROTHER=true 可以关闭内网环境验证和数据上报
        if (process.env.NO_BIGBROTHER === 'true') {
            return true;
        }
        var platform = data.platform;
        // 只收集 LinkE 平台的构建与 Basement 平台的构建。本地构建不上传
        if (!platform.type) {
            log('Skip build, no platform type');
            return true;
        }
        // Basement 和 LinkE 都需要传入 appName
        if (!platform.appName) {
            log('Skip build, no platform appName');
            return true;
        }
        // Basement 平台需要传入 appType
        if (platform.type === enum_1.PLATFORM_TYPE.BASEMENT) {
            if (!platform.appType) {
                log('Skip build, no platform appType');
                return true;
            }
        }
        return false;
    };
    SatoriAdapter.prototype.ifDevReport = function (data) {
        // 环境变量跳过上报: 设置环境变量 NO_BIGBROTHER=true 可以关闭内网环境验证和数据上报
        if (process.env.NO_BIGBROTHER === 'true') {
            return true;
        }
        var git = data.git;
        // 本地若无 git 信息，跳过上报
        if (!git.repository) {
            return true;
        }
        return false;
    };
    // 将上报信息进行存储
    SatoriAdapter.prototype.saveFile = function (reportData) {
        var targetFile = path_1.join(reportData.platform.type === enum_1.PLATFORM_TYPE.BASEMENT ? process.env.HOME : process.env.STATIC_BUILD_SRC, 'build_detail_info.json');
        fs_1.writeFileSync(targetFile, JSON.stringify(reportData), { encoding: 'utf8' });
    };
    return SatoriAdapter;
}());
exports.default = SatoriAdapter;
