function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

/**
 * @fileOverview 分面的基类
 * @author dxq613@gmail.com
 */
var Base = require('./base');
/**
 * 矩形的 facet 有以下属性：
 * - colField 列的字段
 * - rowField 行的字段
 * - colValue 列字段的值
 * - rowValue 行字段的值
 * - cols 列数
 * - rows 行数
 * - colIndex 列的序号
 * - rowIndex 行的序号
 */

/**
 * 用于生成分面的类
 * @class Facets.Rect
 */


var Rect = /*#__PURE__*/function (_Base) {
  _inheritsLoose(Rect, _Base);

  function Rect() {
    return _Base.apply(this, arguments) || this;
  }

  var _proto = Rect.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Base.prototype.getDefaultCfg.call(this);

    cfg.type = 'rect';
    return cfg;
  };

  _proto.generateFacets = function generateFacets(data) {
    var self = this;
    var fields = self.fields; // var defs = self.defs;

    var rst = [];
    var rows = 1;
    var cols = 1;
    var colField = fields[0];
    var rowField = fields[1];
    var colValues = [''];
    var rowValues = [''];

    if (colField) {
      colValues = self.getFieldValues(colField, data);
      cols = colValues.length;
    }

    if (rowField) {
      rowValues = self.getFieldValues(rowField, data);
      rows = rowValues.length;
    } // 获取每个维度对应的frame


    colValues.forEach(function (xVal, xIndex) {
      rowValues.forEach(function (yVal, yIndex) {
        var conditions = [{
          field: colField,
          value: xVal,
          values: colValues
        }, {
          field: rowField,
          value: yVal,
          values: rowValues
        }];
        var filter = self.getFilter(conditions);
        var subData = data.filter(filter);
        var facet = {
          type: self.type,
          colValue: xVal,
          rowValue: yVal,
          colField: colField,
          rowField: rowField,
          colIndex: xIndex,
          rowIndex: yIndex,
          cols: cols,
          rows: rows,
          data: subData,
          region: self.getRegion(rows, cols, xIndex, yIndex)
        };
        rst.push(facet);
      });
    });
    return rst;
  } // 设置 x 坐标轴的文本、title 是否显示
  ;

  _proto.setXAxis = function setXAxis(xField, axes, facet) {
    if (facet.rowIndex !== facet.rows - 1) {
      axes[xField].title = null;
      axes[xField].label = null;
    } else if (facet.colIndex !== parseInt((facet.cols - 1) / 2)) {
      axes[xField].title = null;
    }
  } // 设置 y 坐标轴的文本、title 是否显示
  ;

  _proto.setYAxis = function setYAxis(yField, axes, facet) {
    if (facet.colIndex !== 0) {
      axes[yField].title = null;
      axes[yField].label = null;
    } else if (facet.rowIndex !== parseInt((facet.rows - 1) / 2)) {
      axes[yField].title = null;
    }
  };

  _proto.renderTitle = function renderTitle(view, facet) {
    if (facet.rowIndex === 0) {
      this.drawColTitle(view, facet);
    }

    if (facet.colIndex === facet.cols - 1) {
      this.drawRowTitle(view, facet);
    }
  };

  return Rect;
}(Base);

module.exports = Rect;