function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

/**
 * @fileOverview list facets, support cols
 */
var Base = require('./base');
/**
 * 用于生成分面的类
 * @class Facets.List
 */


var List = /*#__PURE__*/function (_Base) {
  _inheritsLoose(List, _Base);

  function List() {
    return _Base.apply(this, arguments) || this;
  }

  var _proto = List.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Base.prototype.getDefaultCfg.call(this);

    cfg.type = 'list';
    cfg.cols = null; // 用户不设置时就显示一行

    return cfg;
  };

  _proto.generateFacets = function generateFacets(data) {
    var self = this;
    var fields = self.fields;
    var colField = fields[0];

    if (!colField) {
      throw 'Please specify for the field for facet!';
    }

    var colValues = self.getFieldValues(colField, data);
    var count = colValues.length;
    var cols = self.cols || count;
    var rows = parseInt((count + cols - 1) / cols);
    var rst = [];
    colValues.forEach(function (xVal, index) {
      var row = parseInt(index / cols);
      var col = index % cols;
      var conditions = [{
        field: colField,
        value: xVal,
        values: colValues
      }];
      var filter = self.getFilter(conditions);
      var subData = data.filter(filter);
      var facet = {
        type: self.type,
        count: count,
        colValue: xVal,
        colField: colField,
        rowField: null,
        rowValue: xVal,
        colIndex: col,
        rowIndex: row,
        cols: cols,
        rows: rows,
        data: subData,
        region: self.getRegion(rows, cols, col, row)
      };
      rst.push(facet);
    });
    return rst;
  } // 设置 x 坐标轴的文本、title 是否显示
  ;

  _proto.setXAxis = function setXAxis(xField, axes, facet) {
    // 当是最后一行或者下面没有 view 时文本不显示
    if (facet.rowIndex !== facet.rows - 1 && facet.cols * facet.rowIndex + facet.colIndex + 1 + facet.cols <= facet.count) {
      axes[xField].label = null;
      axes[xField].title = null;
    }
  } // 设置 y 坐标轴的文本、title 是否显示
  ;

  _proto.setYAxis = function setYAxis(yField, axes, facet) {
    if (facet.colIndex !== 0) {
      axes[yField].title = null;
      axes[yField].label = null;
    }
  };

  return List;
}(Base);

module.exports = List;