/**
 * 通过搜索获得地图列表(保安人员)
 */
import React, { Component } from "react";
import { connect } from "dva";
import { Pagination, message, Icon, Input, Button, Tooltip } from "antd";
// import "../person.less";
import PersonItem from "./PersonItem";
import { getComPerLocationByKeyword } from "../../../../../services/api";
@connect((state) => ({
  selectedId: state.command.personList.selectedId,
  tabIndex2: state.command.tabIndex.person.tabIndex2,
}))
export default class AllPerson extends Component {
  constructor(props) {
    super(props);
    this.state = {
      tabKey: "1",
      currentKey: null, //主要用于处理tab页面改变，不让重新请求数据
      searchData: {
        pageNumber: 1,
        pageSize: 7,
        keyWord: null,
      },
      personList: [], //人员列表数据
      height: null, //最大高度
      loadingText: "暂无数据",
    };
  }

  componentDidMount() {
    const height = document.documentElement.clientHeight - 120 - 130 - 40;
    this.setState({ height });
    this.getPersonList(1);
  }
  componentWillReceiveProps(nextProps) { 
    if (
      nextProps.tabIndex2 == this.state.tabKey && //定位当前tab页是自己
      nextProps.tabIndex2 !== this.state.currentKey //用于不让数据一直刷新
    ) {
      this.setState({
        currentKey: nextProps.tabIndex2,
      });
      this.getPersonList(this.state.searchData.pageNumber);
    }
    if (nextProps.tabIndex2 != this.state.tabKey) {
      this.setState({
        currentKey: null,
      });
    }
  }
  getPersonList(pageNumber) {
    this.props.dispatch({
      type: "command/setPersonSelectIndex",
      payload: null,
    });
    this.setState(
      {
        searchData: {
          ...this.state.searchData,
          pageNumber,
          pageSize: 7,
        },
        loadingText: "正在加载中...",
      },
      () => {
        getComPerLocationByKeyword({
          ...this.state.searchData,
        }).then((res) => {
          if (res.retType === "0") {
            this.setState({
              personList: res.data.data,
              total: res.data.total,
              loadingText: res.data.data.length > 0 ? "加载完成" : "暂无数据",
            });
            this.props.dispatch({
              type: "command/fetchPersonList",
              payload: {
                list: res.data.data,
              },
            });
          }
        });
      }
    );
  }
  render() {
    return (
      <div className="data-list">
        <div className="input">
          <Input
            placeholder="请输入人员:"
            style={{ width: 270 }}
            onChange={(e) => {
              this.setState({
                searchData: {
                  ...this.state.searchData,
                  keyWord: e.target.value.trim(),
                },
              });
            }}
            onPressEnter={() => {
              //按下回车的事件
              this.getPersonList(1);
            }}
          />
          <Button
            type="primary"
            onClick={() => {
              this.getPersonList(1);
            }}
          >
            <Icon type="search" style={{ fontSize: "16px" }} />
          </Button>
        </div>

        <div className="security search-list_command amap_lib_placeSearch">
          <div
            className="list"
            style={{ maxHeight: this.state.height, overflow: "auto" }}
          >
            <PersonItem
              data={this.state.personList}
              clickTextScheduling={(item, type, isNeedRecord) => {
                this.props.clickTextScheduling(item, type, isNeedRecord);
              }}
              loadingText={this.state.loadingText}
            />
          </div>
          <Pagination
            total={this.state.total}
            size="small"
            onChange={(number) => {
              this.getPersonList(number);
            }}
            defaultPageSize={this.state.searchData.pageSize}
            current={this.state.searchData.pageNumber}
            style={{
              display:
                this.state.total > this.state.searchData.pageSize
                  ? "block"
                  : "none",
            }}
          />
        </div>
      </div>
    );
  }
}
