package com.bcxin.flink.streaming.cores.utils;

import org.apache.flink.util.OperatingSystem;

public class StorageUtil {
    public static String getPath(String busIdentity) {
        String path = "/data/soft/flink/storage/" + busIdentity;
        String businessSubPath = "data";
        /**
         * 加businessSubPath子目录的目的是确保每个job独立
         */
        if (OperatingSystem.isWindows()) {
            path = "e:\\checkpoints\\" + busIdentity + "\\" + businessSubPath;
        } else {
            path += path.concat("/" + businessSubPath);
        }

        return path;
    }

    public static String getTmpPath() {
        String path = "/data/soft/flink/tmp";
        String businessSubPath = "data";
        /**
         * 加businessSubPath子目录的目的是确保每个job独立
         */
        if (OperatingSystem.isWindows()) {
            path = "e:\\checkpoints_tmp\\" + businessSubPath;
        } else {
            path += path.concat("/" + businessSubPath);
        }

        return path;
    }
}
