package com.bcxin.flink.streaming.cores.utils;

import com.bcxin.event.core.KafkaConstants;
import com.bcxin.event.core.exceptions.BadEventException;
import org.apache.kafka.clients.admin.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class KafkaUtils {
    private static Logger logger = LoggerFactory.getLogger(KafkaUtils.class);
    private static ConcurrentHashMap<String, Boolean> hasDoubleCheckedConcurrentMap = new ConcurrentHashMap<>();
    private static volatile boolean isDtqTopic = false;
    private static Set<String> lowerPriorityTopics_for_Replica = Stream.of(
            "dispatch",
            "baibaodunflow.tlk_attendance_project",
            "baibaodunflow.tlk_contracttoenterprise",
            "baibaodunflow.tlk_attendance_site_arrange_info",
            "baibaodunflow.tlk_setsupervise",
            "baibaodunflow.tlk_companyinformation",
            "baibaodunflow.tlk_overseasoperation",
            "baibaodunflow.tlk_subcompanyinformation",
            "baibaodunflow.tlk_managementlayer",
            "baibaodunflow.tlk_shareholderinformation"
            ).collect(Collectors.toSet());

    public static void ensureTopic(String topicName, Properties properties) {
        if(KafkaConstants.getDtqTopic(KafkaConstants.DTQ_JDBC_CONSUMER_TOPIC).equals(topicName)) {
            if (isDtqTopic == true) {
                return;
            }

            isDtqTopic = true;
        }

        boolean isContinue2CreatePartition = true;
        if (!hasDoubleCheckedConcurrentMap.containsKey(topicName)) {
            synchronized (KafkaUtils.class) {
                if (hasDoubleCheckedConcurrentMap.containsKey(topicName)) {
                    return;
                }

                logger.info("[v5]-{}-当前确认的主题为:{}",Thread.currentThread().getId(), topicName);
                for (int index = 0; index < 5; index++) {
                    try (AdminClient adminClient = AdminClient.create(properties)) {
                        int defaultPartition = KafkaConstants.DEFAULT_PARTITION_COUNT;
                        final short defaultReplica = KafkaConstants.DEFAULT_REPLICA_COUNT;
                        Collection<String> topicKeywords =
                                Arrays.stream(topicName.split(".")).collect(Collectors.toSet());
                        if (lowerPriorityTopics_for_Replica.stream().anyMatch(ix->topicKeywords.stream().anyMatch(ii->ii.equalsIgnoreCase(ix)))) {
                            defaultPartition = 1;
                            logger.info("针对用于备份的消息({})队列; 直接采用{}分区的方式进行复制", topicName,defaultPartition);
                        }else {
                            logger.info("针对非备份的消息({})队列; 直接采用{}分区的方式进行复制", topicName, defaultPartition);
                        }
                        try {
                            NewTopic topic = new NewTopic(topicName, defaultPartition, defaultReplica);
                            CreateTopicsResult result = adminClient.createTopics(Arrays.asList(topic));
                            Object oj = result.all().get();
                            break;
                        } catch (Exception ex) {
                            if (ex.getCause() != null && ex.getCause().toString().contains("TopicExistsException")) {
                                hasDoubleCheckedConcurrentMap.put(topicName, true);
                                return;
                            }

                            isContinue2CreatePartition = false;

                            if (index > 3) {
                                throw new BadEventException(ex);
                            }
                        } finally {
                            if (isContinue2CreatePartition) {
                                try {
                                    Map<String, NewPartitions> newPartitions = new HashMap<>();
                                    newPartitions.put(topicName, NewPartitions.increaseTo(defaultPartition));
                                    CreatePartitionsResult result2 = adminClient.createPartitions(newPartitions);
                                    Object oj2 = result2.all().get();

                                    hasDoubleCheckedConcurrentMap.put(topicName, true);
                                } catch (Exception ex) {
                                    if (ex.toString().contains("InvalidPartitionsException")) {
                                        hasDoubleCheckedConcurrentMap.put(topicName, true);
                                        return;
                                    }

                                    throw new BadEventException(ex);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
