package com.bcxin.flink.streaming.cores.properties.impls;

import com.bcxin.flink.streaming.cores.properties.CheckpointConfigProperty;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;

@Getter(AccessLevel.PRIVATE)
@Setter(AccessLevel.PRIVATE)
public class HdfsCheckpointConfigPropertyImpl implements CheckpointConfigProperty {
    /**
     * hdfs://220.243.137.100:9000
     */
    private final String baseSite;

    /**
     * cdc-flink-cp
     */
    private final String contextPath;

    /**
     * 上次的checkpoint路径
     */
    private String lastCheckpointPath;

    private ParameterTool parameterTool;

    private HdfsCheckpointConfigPropertyImpl(String baseSite, String contextPath) {
        this.baseSite = baseSite;
        this.contextPath = contextPath;
    }

    @Override
    public String getSavepointPath() {
        return this.getCheckpointPath();
    }

    @Override
    public String getCheckpointPath() {
        return getBaseSite().concat(getContextPath());
    }


    @Override
    public ParameterTool getArgParameter() {
        return this.parameterTool;
    }

    public static HdfsCheckpointConfigPropertyImpl create(Configuration conf, String baseSite, String contextPath,ParameterTool parameterTool)
            throws IOException {
        HdfsCheckpointConfigPropertyImpl property = new HdfsCheckpointConfigPropertyImpl(baseSite,contextPath);
        property.setParameterTool(parameterTool);
        FileSystem fs = FileSystem.get(conf);
        FileStatus[] fileStatuses = fs.listStatus(new Path(contextPath));
        if (fileStatuses != null) {
            Optional<FileStatus> fileStatusOptional =
                    Arrays.stream(fileStatuses)
                            .sorted((i1, i2) -> i1.getModificationTime() > i2.getModificationTime() ? 1 : 0)
                            .findFirst();
            if (fileStatusOptional.isPresent()) {
                FileStatus lastFileStatus = fileStatusOptional.get();
                Optional<FileStatus> lastCheckpointFileStatusOptional = Arrays.stream(fs.listStatus(
                        new Path(contextPath.concat(File.separator).concat(lastFileStatus.getPath().getName())
                        )
                        , ii -> {
                            boolean flag = ii.getName().startsWith(CheckpointConfigProperty.DYNAMIC_CHK_PREFIX);

                            if (flag) {
                                try {
                                    FileStatus[] subFileStatuses = fs.listStatus(ii);
                                    flag = Arrays.stream(subFileStatuses).filter(ix -> ix.isFile())
                                            .anyMatch(ix -> ix.getPath().getName().equalsIgnoreCase(CheckpointConfigProperty.CHECK_POINT_META));
                                } catch (IOException e) {
                                    e.printStackTrace();
                                    flag = false;
                                }
                            }

                            return flag;
                        })).findFirst();
                if (lastCheckpointFileStatusOptional.isPresent()) {
                    FileStatus lastCheckpointFileStatus = lastCheckpointFileStatusOptional.get();
                    property.setLastCheckpointPath(lastCheckpointFileStatus.getPath().toString());
                }
            }
        }
        return property;
    }
}
