package com.bcxin.flink.streaming.cores;

import com.bcxin.event.core.exceptions.BadEventException;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class SystemPropertyUtil {
    public static Properties loadEnvConf(String env) throws IOException {
        Properties properties = System.getProperties();

        ClassLoader classLoader = SystemPropertyUtil.class.getClassLoader();
        try (InputStream coreStream = classLoader.getResourceAsStream(
                String.format("jdbcs/task-%s.properties", env))) {
            if (coreStream == null) {
                throw new BadEventException(String.format("找不到该环境配置:%s", env));
            }

            properties.load(coreStream);
        }

        properties.put(TableConstant.PARAM_ENV, env);

        return properties;
    }
}
