package com.bcxin.flink.streaming.cores;

import com.bcxin.event.core.*;
import com.bcxin.event.core.dtos.HttpDomainRegionDTO;
import com.bcxin.event.core.enums.JobType;
import com.bcxin.event.core.exceptions.BadEventException;
import com.bcxin.flink.streaming.cores.dtos.JdbcConnectionDto;
import com.mysql.cj.jdbc.Driver;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.util.FlinkUserCodeClassLoader;

import javax.sql.DataSource;
import java.sql.*;
import java.util.*;
import java.util.stream.Collectors;

public class JdbcJobExecutorUtil {
    public static JobParameterDTO getJobParameter(int jobId) {
        try {
            JsonProvider jsonProvider = new JsonProviderImpl();
            try (Connection connection = getConnection()) {
                try (PreparedStatement statement = connection.prepareStatement("select * from flink_jobs where id=? and is_online=1")) {
                    statement.setInt(1, jobId);

                    try (ResultSet resultSet = statement.executeQuery()) {
                        while (resultSet.next()) {
                            String name = resultSet.getString("name");
                            int type = (Integer) resultSet.getObject("job_type");
                            JobType job_type = Arrays.stream(JobType.values()).filter(ix -> ix.ordinal() == type).findFirst().get();
                            String parameter_json = resultSet.getString("parameter_json");
                            String description = resultSet.getString("description");

                            JobParameterDTO parameterDTO = JobParameterDTO.create(name, job_type, parameter_json, description);

                            String param2 = parameterDTO.getParam2(jsonProvider);
                            JdbcSqlTemplateDefinition jdbcSqlTemplateDefinition = jsonProvider.toObject(JdbcSqlTemplateDefinition.class, param2);
                            if (jdbcSqlTemplateDefinition != null && jdbcSqlTemplateDefinition.getJdbcId() == null) {

                            }

                            return parameterDTO;
                        }

                        return null;
                    }
                }
            }
        } catch (Exception ex) {
            throw new BadEventException("", ex);
        }
    }

    public static Collection<JdbcParameterDTO> getJdbcParameterDTO(List<Long> jdbcIds) {
        try {
            try (Connection connection = getConnection()) {
                StringBuilder inWhere = new StringBuilder("id in (");
                for(int index=0;index<jdbcIds.size();index++) {
                    inWhere.append("?");
                    if (index != jdbcIds.size() - 1) {
                        inWhere.append(",");
                    }
                }
                inWhere.append(")");

                String sql = String.format("select id,`name`,drive_class_name,url,user_name,password,server_time_zone from flink_jdbc_definitions where %s",inWhere);

                try (PreparedStatement statement = connection.prepareStatement(sql)) {
                    for(int index=0;index<jdbcIds.size();index++) {
                        statement.setObject(index + 1, jdbcIds.get(index));
                    }

                    Collection<JdbcParameterDTO> jdbcParameterDTOS = new ArrayList<>();

                    try (ResultSet resultSet = statement.executeQuery()) {
                        while (resultSet.next()) {
                            Long id = resultSet.getLong("id");
                            String name = resultSet.getString("name");
                            String driveClassName = resultSet.getString("drive_class_name");
                            String url = resultSet.getString("url");
                            String user_name = resultSet.getString("user_name");
                            String password = resultSet.getString("password");
                            String connectionTimeZone = resultSet.getString("server_time_zone");

                            JdbcParameterDTO parameterDTO = JdbcParameterDTO.create(id, name, url, user_name, password, connectionTimeZone, driveClassName);
                            jdbcParameterDTOS.add(parameterDTO);
                        }

                        return jdbcParameterDTOS;
                    }
                }
            }
        } catch (Exception ex) {
            throw new BadEventException("", ex);
        }
    }

    private static Set<HttpDomainRegionDTO> domainRegionDTOS = new HashSet<>();
    public static final Collection<HttpDomainRegionDTO> getDomainRegionDTOs(Collection<String> domainIds, Connection connection) {

        Collection<String> notExistsDomainIds = domainIds.stream()
                .filter(ix -> !domainRegionDTOS.stream().anyMatch(it -> it.getDomainId().equalsIgnoreCase(ix)))
                .collect(Collectors.toList());

        if (!CollectionUtils.isEmpty(notExistsDomainIds)) {
            synchronized (domainRegionDTOS) {
                String sql =
                        String.format(
                                "select id,supervise_depart_id,supervise_region_code from tenant_organizations where id in (%s)",
                                notExistsDomainIds.stream().map(ix -> String.format("'%s'", ix))
                                        .collect(Collectors.joining(","))
                        );

                try {
                    try (PreparedStatement statement = connection.prepareStatement(sql)) {
                        try (ResultSet resultSet = statement.executeQuery()) {
                            while (resultSet.next()) {
                                String id = resultSet.getString("id");
                                String supervise_depart_id = resultSet.getString("supervise_depart_id");
                                String supervise_region_code = resultSet.getString("supervise_region_code");
                                if (!StringUtils.isEmpty(supervise_depart_id)) {
                                    HttpDomainRegionDTO domainRegion =
                                            HttpDomainRegionDTO.create(
                                                    id, supervise_depart_id, supervise_region_code
                                            );
                                    domainRegionDTOS.add(domainRegion);
                                }
                            }
                        }
                    }
                } catch (Exception ex) {
                    throw new BadEventException("获取企业的监管的区域信息xxxx:" + sql, ex);
                }
            }
        }

        return domainRegionDTOS.stream()
                .filter(ix -> domainIds.contains(ix.getDomainId()))
                .collect(Collectors.toList());
    }

    /**
     * 仅能在主线程中执行; 否则System.getProperties取不到数据
     * @return
     */
    private static Connection getConnection() {
        String driverClassName =
                System.getProperties().getProperty("datasource.driver-class-name");
        String url =
                System.getProperties().getProperty("datasource.url");
        String userName =
                System.getProperties().getProperty("datasource.username");
        String password =
                System.getProperties().getProperty("datasource.password");
        if (StringUtils.isEmpty(driverClassName) || StringUtils.isEmpty(userName) ||
                StringUtils.isEmpty(userName) || StringUtils.isEmpty(password)) {
            throw new BadEventException(String.format("driverClassName=%s;url=%s;userName=%s;password=%s;",
                    driverClassName, url, userName, password));
        }

        return getConnection(JdbcConnectionDto.create(
                driverClassName, url, userName, password)
        );
    }

    public static Connection getConnection(JdbcConnectionDto jdbcConnection) {
        try {
            return
                    DataSourceUtil.getDataSource(jdbcConnection.getDriverClassName(),
                                    jdbcConnection.getUrl(), jdbcConnection.getUserName(),
                                    jdbcConnection.getPassword())
                            .getConnection();
        } catch (Exception ex) {
            ex.printStackTrace();
            throw new BadEventException("获取Jdbc连接发送异常.v8", ex);
        }
    }
}
